/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleLines;

public class TestLineParticles
extends SimpleGame {
    private ParticleLines pLines;
    private Vector3f currentPos = new Vector3f();
    private Vector3f newPos = new Vector3f();
    private float frameRate = 0.0f;

    public static void main(String[] stringArray) {
        TestLineParticles testLineParticles = new TestLineParticles();
        testLineParticles.setDialogBehaviour(2);
        testLineParticles.start();
    }

    protected void simpleUpdate() {
        if (this.tpf > 1.0f) {
            this.tpf = 1.0f;
        }
        if ((int)this.currentPos.x == (int)this.newPos.x && (int)this.currentPos.y == (int)this.newPos.y && (int)this.currentPos.z == (int)this.newPos.z) {
            this.newPos.x = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.y = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.z = (float)Math.random() * 50.0f - 150.0f;
        }
        this.frameRate = this.timer.getFrameRate() / 2.0f;
        this.currentPos.x -= (this.currentPos.x - this.newPos.x) / this.frameRate;
        this.currentPos.y -= (this.currentPos.y - this.newPos.y) / this.frameRate;
        this.currentPos.z -= (this.currentPos.z - this.newPos.z) / this.frameRate;
        this.pLines.setOriginOffset(this.currentPos);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Particle System - Line Particles");
        this.lightState.setEnabled(false);
        this.pLines = ParticleFactory.buildLineParticles((String)"particles", (int)300);
        this.pLines.setLineWidth(3.0f);
        this.pLines.setMode(0);
        this.pLines.setAntialiased(true);
        this.pLines.setParticleOrientation(1.5707964f);
        this.pLines.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        this.pLines.setOriginOffset(new Vector3f(0.0f, 0.0f, 0.0f));
        this.pLines.setInitialVelocity(0.006f);
        this.pLines.setStartSize(4.0f);
        this.pLines.setEndSize(1.5f);
        this.pLines.setMinimumLifeTime(1250.0f);
        this.pLines.setMaximumLifeTime(1800.0f);
        this.pLines.setParticleSpinSpeed((float)Math.PI * 3);
        this.pLines.setStartColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        this.pLines.setEndColor(new ColorRGBA(0.0f, 1.0f, 0.0f, 0.0f));
        this.pLines.setMaximumAngle((float)Math.PI * 2);
        this.pLines.getParticleController().setControlFlow(false);
        this.pLines.warmUp(120);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)alphaState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.pLines.setRenderState((RenderState)zBufferState);
        this.pLines.setModelBound((BoundingVolume)new BoundingSphere());
        this.pLines.updateModelBound();
        this.rootNode.attachChild((Spatial)this.pLines);
    }
}

