/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleMesh;
import java.net.URL;

public class TestParticleSystem
extends SimpleGame {
    private ParticleMesh pMesh;
    private Vector3f currentPos = new Vector3f();
    private Vector3f newPos = new Vector3f();
    private float frameRate = 0.0f;

    public static void main(String[] stringArray) {
        TestParticleSystem testParticleSystem = new TestParticleSystem();
        testParticleSystem.setDialogBehaviour(2);
        testParticleSystem.start();
    }

    protected void simpleUpdate() {
        if (this.tpf > 1.0f) {
            this.tpf = 1.0f;
        }
        if ((int)this.currentPos.x == (int)this.newPos.x && (int)this.currentPos.y == (int)this.newPos.y && (int)this.currentPos.z == (int)this.newPos.z) {
            this.newPos.x = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.y = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.z = (float)Math.random() * 50.0f - 150.0f;
        }
        this.frameRate = this.timer.getFrameRate() / 2.0f;
        this.currentPos.x -= (this.currentPos.x - this.newPos.x) / this.frameRate;
        this.currentPos.y -= (this.currentPos.y - this.newPos.y) / this.frameRate;
        this.currentPos.z -= (this.currentPos.z - this.newPos.z) / this.frameRate;
        this.pMesh.setOriginOffset(this.currentPos);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Particle System");
        this.lightState.setEnabled(false);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestParticleSystem.class.getClassLoader().getResource("jmetest/data/texture/flaresmall.jpg"), (int)6, (int)1));
        textureState.setEnabled(true);
        this.pMesh = ParticleFactory.buildParticles((String)"particles", (int)300);
        this.pMesh.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        this.pMesh.setInitialVelocity(0.006f);
        this.pMesh.setStartSize(2.5f);
        this.pMesh.setEndSize(0.5f);
        this.pMesh.setMinimumLifeTime(1200.0f);
        this.pMesh.setMaximumLifeTime(1400.0f);
        this.pMesh.setStartColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        this.pMesh.setEndColor(new ColorRGBA(0.0f, 1.0f, 0.0f, 0.0f));
        this.pMesh.setMaximumAngle((float)Math.PI * 2);
        this.pMesh.getParticleController().setControlFlow(false);
        this.pMesh.warmUp(60);
        this.rootNode.setRenderState((RenderState)textureState);
        this.rootNode.setRenderState((RenderState)alphaState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.pMesh.setRenderState((RenderState)zBufferState);
        this.pMesh.setModelBound((BoundingVolume)new BoundingSphere());
        this.pMesh.updateModelBound();
        this.rootNode.attachChild((Spatial)this.pMesh);
    }
}

