/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects.glsl;

import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.effects.glsl.BloomRenderPass;
import com.jmex.model.XMLparser.Converters.MaxToJme;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jmetest.renderer.loader.TestMaxJmeWrite;

public class TestBloom
extends SimplePassGame {
    private BloomRenderPass bloomRenderPass;
    private int screenshotIndex = 0;

    public static void main(String[] stringArray) {
        TestBloom testBloom = new TestBloom();
        testBloom.setDialogBehaviour(2);
        testBloom.start();
    }

    protected void cleanup() {
        super.cleanup();
        if (this.bloomRenderPass != null) {
            this.bloomRenderPass.cleanup();
        }
    }

    protected void simpleInitGame() {
        ByteArrayOutputStream byteArrayOutputStream;
        MaxToJme maxToJme;
        this.cam.setFrustumPerspective(55.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 5000.0f);
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(0.0f, 30.0f, 0.0f));
        pointLight.setEnabled(true);
        this.lightState.attach((Light)pointLight);
        this.rootNode.attachChild((Spatial)this.createObjects());
        try {
            maxToJme = new MaxToJme();
            byteArrayOutputStream = new ByteArrayOutputStream();
            URL uRL = TestMaxJmeWrite.class.getClassLoader().getResource("jmetest/data/model/Character.3DS");
            maxToJme.convert((InputStream)new BufferedInputStream(uRL.openStream()), (OutputStream)byteArrayOutputStream);
            Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            node.getController(0).setRepeatType(1);
            node.setLocalScale(0.1f);
            if (node.getChild(0).getControllers().size() != 0) {
                node.getChild(0).getController(0).setSpeed(20.0f);
            }
            Quaternion quaternion = new Quaternion();
            quaternion.fromAngleAxis(1.5707964f, new Vector3f(-1.0f, 0.0f, 0.0f));
            node.setLocalRotation(quaternion);
            node.setLocalTranslation(new Vector3f(0.0f, 3.0f, 0.0f));
            this.rootNode.attachChild((Spatial)node);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        maxToJme = new RenderPass();
        maxToJme.add((Spatial)this.rootNode);
        this.pManager.add((Pass)maxToJme);
        this.bloomRenderPass = new BloomRenderPass(this.cam, 4);
        if (!this.bloomRenderPass.isSupported()) {
            byteArrayOutputStream = new Text("Text", "GLSL Not supported on this computer.");
            byteArrayOutputStream.setRenderQueueMode(4);
            byteArrayOutputStream.setLightCombineMode(0);
            byteArrayOutputStream.setLocalTranslation(new Vector3f(0.0f, 20.0f, 0.0f));
            this.fpsNode.attachChild((Spatial)byteArrayOutputStream);
        } else {
            this.bloomRenderPass.add((Spatial)this.rootNode);
            this.bloomRenderPass.setUseCurrentScene(true);
            this.pManager.add((Pass)this.bloomRenderPass);
        }
        byteArrayOutputStream = new RenderPass();
        byteArrayOutputStream.add((Spatial)this.fpsNode);
        this.pManager.add((Pass)byteArrayOutputStream);
        KeyBindingManager.getKeyBindingManager().set("1", 2);
        KeyBindingManager.getKeyBindingManager().set("2", 3);
        KeyBindingManager.getKeyBindingManager().set("3", 4);
        KeyBindingManager.getKeyBindingManager().set("4", 5);
        KeyBindingManager.getKeyBindingManager().set("5", 6);
        KeyBindingManager.getKeyBindingManager().set("6", 7);
        KeyBindingManager.getKeyBindingManager().set("7", 8);
        KeyBindingManager.getKeyBindingManager().set("8", 9);
        KeyBindingManager.getKeyBindingManager().set("9", 10);
        KeyBindingManager.getKeyBindingManager().set("0", 11);
        KeyBindingManager.getKeyBindingManager().set("`", 41);
        KeyBindingManager.getKeyBindingManager().set("-", 74);
        KeyBindingManager.getKeyBindingManager().set("+", 78);
        KeyBindingManager.getKeyBindingManager().set("shot", 62);
    }

    protected void simpleUpdate() {
        float f;
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("1", false)) {
            this.bloomRenderPass.setEnabled(!this.bloomRenderPass.isEnabled());
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("2", false)) {
            this.bloomRenderPass.setBlurSize(this.bloomRenderPass.getBlurSize() - 0.001f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("3", false)) {
            this.bloomRenderPass.setBlurSize(this.bloomRenderPass.getBlurSize() + 0.001f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("4", false)) {
            this.bloomRenderPass.setExposurePow(this.bloomRenderPass.getExposurePow() - 1.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("5", false)) {
            this.bloomRenderPass.setExposurePow(this.bloomRenderPass.getExposurePow() + 1.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("6", false)) {
            this.bloomRenderPass.setExposureCutoff(this.bloomRenderPass.getExposureCutoff() - 0.1f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("7", false)) {
            this.bloomRenderPass.setExposureCutoff(this.bloomRenderPass.getExposureCutoff() + 0.1f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("8", false)) {
            this.bloomRenderPass.setBlurIntensityMultiplier(this.bloomRenderPass.getBlurIntensityMultiplier() - 0.1f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("9", false)) {
            this.bloomRenderPass.setBlurIntensityMultiplier(this.bloomRenderPass.getBlurIntensityMultiplier() + 0.1f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("0", false)) {
            this.bloomRenderPass.resetParameters();
            this.bloomRenderPass.setUseCurrentScene(true);
            this.bloomRenderPass.setThrottle(0.02f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("`", false)) {
            this.bloomRenderPass.setUseCurrentScene(!this.bloomRenderPass.useCurrentScene());
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("-", false)) {
            f = this.bloomRenderPass.getThrottle() - 0.005f;
            if (f < 0.0f) {
                f = 0.0f;
            }
            System.err.println("throttle: " + f);
            this.bloomRenderPass.setThrottle(f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("+", false)) {
            f = this.bloomRenderPass.getThrottle() + 0.005f;
            System.err.println("throttle: " + f);
            this.bloomRenderPass.setThrottle(f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("shot", false)) {
            this.display.getRenderer().takeScreenShot("shot" + this.screenshotIndex++);
        }
    }

    private Node createObjects() {
        Node node = new Node("objects");
        Torus torus = new Torus("Torus", 50, 50, 10.0f, 20.0f);
        torus.setLocalTranslation(new Vector3f(50.0f, -5.0f, 20.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestBloom.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestBloom.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)6, (int)1);
        texture2.setEnvironmentalMapMode(2);
        textureState.setTexture(texture, 0);
        textureState.setTexture(texture2, 1);
        textureState.setEnabled(true);
        torus.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)torus);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestBloom.class.getClassLoader().getResource("jmetest/data/texture/wall.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        Box box = new Box("box1", new Vector3f(-10.0f, -10.0f, -10.0f), new Vector3f(10.0f, 10.0f, 10.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -7.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box2", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(15.0f, 10.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box3", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -10.0f, 15.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box4", new Vector3f(-5.0f, -5.0f, -5.0f), new Vector3f(5.0f, 5.0f, 5.0f));
        box.setLocalTranslation(new Vector3f(20.0f, 0.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        node.attachChild((Spatial)box);
        box = new Box("box5", new Vector3f(-50.0f, -2.0f, -50.0f), new Vector3f(50.0f, 2.0f, 50.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -15.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        node.attachChild((Spatial)box);
        textureState = this.display.getRenderer().createTextureState();
        texture = TextureManager.loadTexture((URL)TestBloom.class.getClassLoader().getResource("jmetest/data/texture/cloud_land.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        box = new Box("floor", new Vector3f(-1000.0f, -10.0f, -1000.0f), new Vector3f(1000.0f, 10.0f, 1000.0f));
        box.setLocalTranslation(new Vector3f(0.0f, -100.0f, 0.0f));
        box.setRenderState((RenderState)textureState);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        node.attachChild((Spatial)box);
        return node;
    }
}

