/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects.water;

import com.jme.app.SimpleGame;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.effects.water.HeightGenerator;
import com.jmex.effects.water.ProjectedGrid;
import java.net.URL;

public class TestProjectedGrid
extends SimpleGame {
    ProjectedGrid projectedGrid;

    public static void main(String[] stringArray) {
        TestProjectedGrid testProjectedGrid = new TestProjectedGrid();
        testProjectedGrid.setDialogBehaviour(2);
        testProjectedGrid.start();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("f", false)) {
            this.projectedGrid.switchFreeze();
        }
    }

    protected void simpleInitGame() {
        this.display.setTitle("Projected grid test");
        this.cam.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
        this.cam.setLocation(new Vector3f(0.0f, 50.0f, 0.0f));
        this.cam.update();
        this.setupFog();
        this.setupProjectedGrid();
        KeyBindingManager.getKeyBindingManager().set("f", 33);
        KeyBindingManager.getKeyBindingManager().set("1", 2);
        this.rootNode.setCullMode(3);
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(2);
    }

    private void setupProjectedGrid() {
        this.projectedGrid = new ProjectedGrid("Terrain", this.cam, 100, 80, 0.01f, new HeightGenerator(){

            public float getHeight(float f, float f2, float f3) {
                return FastMath.abs((float)(FastMath.sin((float)(f * 0.01f)) * FastMath.cos((float)(f2 * 0.01f)) * 30.0f + FastMath.sin((float)(f * 0.1f)) * FastMath.cos((float)(f2 * 0.1f)) * 5.0f));
            }
        });
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestProjectedGrid.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        textureState.setEnabled(true);
        this.projectedGrid.setRenderState((RenderState)textureState);
        this.projectedGrid.updateRenderState();
        this.rootNode.attachChild((Spatial)this.projectedGrid);
    }

    private void setupFog() {
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setDensity(1.0f);
        fogState.setEnabled(true);
        fogState.setColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        fogState.setEnd(1000.0f);
        fogState.setStart(0.0f);
        fogState.setDensityFunction(0);
        fogState.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)fogState);
    }
}

