/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.MidPointHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import javax.swing.ImageIcon;
import jmetest.terrain.TestTerrain;

public class Lesson3
extends BaseGame {
    private TerrainBlock tb;
    protected Timer timer;
    private Camera cam;
    private Node scene;
    private int width;
    private int height;
    private int depth;
    private int freq;
    private boolean fullscreen;

    public static void main(String[] stringArray) {
        Lesson3 lesson3 = new Lesson3();
        lesson3.setDialogBehaviour(2, Lesson3.class.getClassLoader().getResource("jmetest/data/images/FlagRush.png"));
        lesson3.start();
    }

    protected void update(float f) {
        this.timer.update();
        f = this.timer.getTimePerFrame();
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit")) {
            this.finished = true;
        }
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        this.width = this.properties.getWidth();
        this.height = this.properties.getHeight();
        this.depth = this.properties.getDepth();
        this.freq = this.properties.getFreq();
        this.fullscreen = this.properties.getFullscreen();
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
            this.cam = this.display.getRenderer().createCamera(this.width, this.height);
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black);
        this.cam.setFrustumPerspective(45.0f, (float)this.width / (float)this.height, 1.0f, 1000.0f);
        Vector3f vector3f = new Vector3f(500.0f, 150.0f, 500.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.cam.update();
        this.timer = Timer.getTimer();
        this.display.getRenderer().setCamera(this.cam);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void initGame() {
        this.scene = new Node("Scene graph node");
        this.buildTerrain();
        this.scene.attachChild((Spatial)this.tb);
        this.buildLighting();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    private void buildLighting() {
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(1.0f, -1.0f, 0.0f));
        directionalLight.setEnabled(true);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.attach((Light)directionalLight);
        this.scene.setRenderState((RenderState)lightState);
    }

    private void buildTerrain() {
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(64, 1.0f);
        Vector3f vector3f = new Vector3f(20.0f, 0.5f, 20.0f);
        this.tb = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        this.tb.setModelBound((BoundingVolume)new BoundingBox());
        this.tb.updateModelBound();
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)midPointHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(32);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        this.tb.setRenderState((RenderState)textureState);
    }

    protected void reinit() {
        this.display.recreateWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
    }

    protected void quit() {
        super.quit();
        System.exit(0);
    }

    protected void cleanup() {
    }
}

