/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut.lesson6;

import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.action.InputActionInterface;
import jmetest.flagrushtut.lesson6.Vehicle;
import jmetest.flagrushtut.lesson6.actions.AccelerateAction;
import jmetest.flagrushtut.lesson6.actions.BrakeAction;
import jmetest.flagrushtut.lesson6.actions.DriftAction;
import jmetest.flagrushtut.lesson6.actions.VehicleRotateLeftAction;
import jmetest.flagrushtut.lesson6.actions.VehicleRotateRightAction;

public class FlagRushHandler
extends InputHandler {
    private Vehicle vehicle;
    private DriftAction drift;

    public void update(float f) {
        if (!this.isEnabled()) {
            return;
        }
        super.update(f);
        this.drift.performAction(this.event);
    }

    public FlagRushHandler(Vehicle vehicle, String string) {
        this.vehicle = vehicle;
        this.setKeyBindings(string);
        this.setActions(vehicle);
    }

    private void setKeyBindings(String string) {
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set("forward", 17);
        keyBindingManager.set("backward", 31);
        keyBindingManager.set("turnRight", 32);
        keyBindingManager.set("turnLeft", 30);
    }

    private void setActions(Vehicle vehicle) {
        AccelerateAction accelerateAction = new AccelerateAction(vehicle);
        this.addAction((InputActionInterface)accelerateAction, "forward", true);
        BrakeAction brakeAction = new BrakeAction(vehicle);
        this.addAction((InputActionInterface)brakeAction, "backward", true);
        VehicleRotateRightAction vehicleRotateRightAction = new VehicleRotateRightAction(vehicle);
        this.addAction((InputActionInterface)vehicleRotateRightAction, "turnRight", true);
        VehicleRotateLeftAction vehicleRotateLeftAction = new VehicleRotateLeftAction(vehicle);
        this.addAction((InputActionInterface)vehicleRotateLeftAction, "turnLeft", true);
        this.drift = new DriftAction(vehicle);
    }
}

