/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut.lesson9;

import com.jme.light.Light;
import com.jme.light.LightNode;
import com.jme.light.PointLight;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.math.spring.SpringPoint;
import com.jme.math.spring.SpringPointForce;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Cylinder;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.effects.cloth.ClothPatch;
import com.jmex.effects.cloth.ClothUtils;
import com.jmex.terrain.TerrainBlock;
import java.net.URL;
import jmetest.effects.cloth.TestCloth;

public class Flag
extends Node {
    private static final long serialVersionUID = 1L;
    private static final int LIFE_TIME = 10;
    float countdown = 10.0f;
    TerrainBlock tb;
    private ClothPatch cloth;
    private float windStrength = 15.0f;
    private Vector3f windDirection = new Vector3f(0.8f, 0.0f, 0.2f);
    private SpringPointForce gravity;
    private SpringPointForce wind;

    public Flag(TerrainBlock terrainBlock) {
        super("flag");
        int n;
        this.tb = terrainBlock;
        this.cloth = new ClothPatch("cloth", 25, 25, 1.0f, 10.0f);
        this.wind = new RandomFlagWindForce(this.windStrength, this.windDirection);
        this.cloth.addForce(this.wind);
        this.gravity = ClothUtils.createBasicGravity();
        this.cloth.addForce(this.gravity);
        Cylinder cylinder = new Cylinder("pole", 10, 10, 0.5f, 50.0f);
        this.attachChild((Spatial)cylinder);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(1.5707964f, new Vector3f(1.0f, 0.0f, 0.0f));
        cylinder.setLocalRotation(quaternion);
        cylinder.setLocalTranslation(new Vector3f(-12.5f, -12.5f, 0.0f));
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestCloth.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        PointLight pointLight = new PointLight();
        pointLight.setEnabled(true);
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(0.5f, -0.5f, 0.0f));
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.setTwoSidedLighting(true);
        LightNode lightNode = new LightNode("light", lightState);
        lightNode.setLight((Light)pointLight);
        lightNode.setLocalTranslation(new Vector3f(15.0f, 10.0f, 0.0f));
        lightNode.setTarget((Spatial)this);
        this.attachChild((Spatial)lightNode);
        this.cloth.setRenderState((RenderState)textureState);
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setCullMode(0);
        this.cloth.setRenderState((RenderState)cullState);
        this.attachChild((Spatial)this.cloth);
        for (n = 0; n < 5; ++n) {
            this.cloth.getSystem().getNode((int)(n * 25)).position.y *= 0.8f;
            this.cloth.getSystem().getNode(n * 25).setMass(Float.POSITIVE_INFINITY);
        }
        for (n = 24; n > 19; --n) {
            this.cloth.getSystem().getNode((int)(n * 25)).position.y *= 0.8f;
            this.cloth.getSystem().getNode(n * 25).setMass(Float.POSITIVE_INFINITY);
        }
        this.setRenderQueueMode(2);
        this.setLocalScale(0.25f);
    }

    public void update(float f) {
        this.countdown -= f;
        if (this.countdown <= 0.0f) {
            this.reset();
        }
    }

    public void reset() {
        this.countdown = 10.0f;
        this.placeFlag();
    }

    public void placeFlag() {
        float f = 45.0f + FastMath.nextRandomFloat() * 130.0f;
        float f2 = 45.0f + FastMath.nextRandomFloat() * 130.0f;
        float f3 = this.tb.getHeight(f, f2) + 7.5f;
        this.localTranslation.x = f;
        this.localTranslation.y = f3;
        this.localTranslation.z = f2;
    }

    private class RandomFlagWindForce
    extends SpringPointForce {
        private final float strength;
        private final Vector3f windDirection;

        public RandomFlagWindForce(float f, Vector3f vector3f) {
            this.strength = f;
            this.windDirection = vector3f;
        }

        public void apply(float f, SpringPoint springPoint) {
            this.windDirection.x += f * (FastMath.nextRandomFloat() - 0.5f);
            this.windDirection.z += f * (FastMath.nextRandomFloat() - 0.5f);
            this.windDirection.normalize();
            float f2 = FastMath.nextRandomFloat() * this.strength;
            springPoint.acceleration.addLocal(this.windDirection.x * f2, this.windDirection.y * f2, this.windDirection.z * f2);
        }
    }
}

