/*
 * Decompiled with CFR 0.152.
 */
package jmetest.flagrushtut.lesson9;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.ChaseCamera;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.BasicPassManager;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.renderer.pass.ShadowedRenderPass;
import com.jme.scene.Node;
import com.jme.scene.Skybox;
import com.jme.scene.Spatial;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jmex.model.XMLparser.JmeBinaryReader;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.MidPointHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import jmetest.flagrushtut.lesson9.Flag;
import jmetest.flagrushtut.lesson9.FlagRushHandler;
import jmetest.flagrushtut.lesson9.ForceFieldFence;
import jmetest.flagrushtut.lesson9.Vehicle;
import jmetest.renderer.ShadowTweaker;
import jmetest.renderer.TestSkybox;
import jmetest.terrain.TestTerrain;

public class Lesson9
extends BaseGame {
    private TerrainBlock tb;
    private ForceFieldFence fence;
    private Skybox skybox;
    private Vehicle player;
    private Flag flag;
    protected InputHandler input;
    protected Timer timer;
    private Camera cam;
    private ChaseCamera chaser;
    private Node scene;
    private int width;
    private int height;
    private int depth;
    private int freq;
    private boolean fullscreen;
    private Vector3f normal = new Vector3f();
    private float agl;
    private static ShadowedRenderPass shadowPass = new ShadowedRenderPass();
    private BasicPassManager passManager;

    public static void main(String[] stringArray) {
        Lesson9 lesson9 = new Lesson9();
        lesson9.setDialogBehaviour(2, Lesson9.class.getClassLoader().getResource("jmetest/data/images/FlagRush.png"));
        new ShadowTweaker(shadowPass).setVisible(true);
        lesson9.start();
    }

    protected void update(float f) {
        float f2;
        this.timer.update();
        f = this.timer.getTimePerFrame();
        this.input.update(f);
        this.chaser.update(f);
        this.fence.update(f);
        this.flag.update(f);
        this.skybox.setLocalTranslation(this.cam.getLocation());
        this.skybox.updateGeometricState(0.0f, true);
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit")) {
            this.finished = true;
        }
        if (this.cam.getLocation().y < this.tb.getHeight(this.cam.getLocation()) + 2.0f) {
            this.cam.getLocation().y = this.tb.getHeight(this.cam.getLocation()) + 2.0f;
            this.cam.update();
        }
        if (!Float.isInfinite(f2 = this.tb.getHeight(this.player.getLocalTranslation()) + this.agl) && !Float.isNaN(f2)) {
            this.player.getLocalTranslation().y = f2;
        }
        this.tb.getSurfaceNormal(this.player.getLocalTranslation(), this.normal);
        if (this.normal != null) {
            this.player.rotateUpTo(this.normal);
        }
        this.scene.updateGeometricState(f, true);
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.passManager.renderPasses(this.display.getRenderer());
    }

    protected void initSystem() {
        this.width = this.properties.getWidth();
        this.height = this.properties.getHeight();
        this.depth = this.properties.getDepth();
        this.freq = this.properties.getFreq();
        this.fullscreen = this.properties.getFullscreen();
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.setMinStencilBits(8);
            this.display.createWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
            this.cam = this.display.getRenderer().createCamera(this.width, this.height);
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black);
        this.cam.setFrustumPerspective(45.0f, (float)this.width / (float)this.height, 1.0f, 5000.0f);
        this.cam.setLocation(new Vector3f(200.0f, 1000.0f, 200.0f));
        this.cam.update();
        this.timer = Timer.getTimer();
        this.display.getRenderer().setCamera(this.cam);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void initGame() {
        this.display.setTitle("Flag Rush");
        this.scene = new Node("Scene graph node");
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.scene.setRenderState((RenderState)zBufferState);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        this.scene.setRenderState((RenderState)cullState);
        this.buildTerrain();
        this.buildFlag();
        this.buildLighting();
        this.buildEnvironment();
        this.buildSkyBox();
        this.buildPlayer();
        this.buildChaseCamera();
        this.buildInput();
        this.buildPassManager();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    private void buildPassManager() {
        this.passManager = new BasicPassManager();
        RenderPass renderPass = new RenderPass();
        renderPass.add((Spatial)this.skybox);
        this.passManager.add((Pass)renderPass);
        shadowPass.add((Spatial)this.scene);
        shadowPass.addOccluder((Spatial)this.player);
        shadowPass.setRenderShadows(true);
        shadowPass.setLightingMethod(1);
        this.passManager.add((Pass)shadowPass);
    }

    private void buildFlag() {
        this.flag = new Flag(this.tb);
        this.scene.attachChild((Spatial)this.flag);
        this.flag.placeFlag();
    }

    private void buildPlayer() {
        Node node = null;
        try {
            URL uRL = Lesson9.class.getClassLoader().getResource("jmetest/data/model/bike.jme");
            JmeBinaryReader jmeBinaryReader = new JmeBinaryReader();
            jmeBinaryReader.setProperty("bound", (Object)"box");
            node = jmeBinaryReader.loadBinaryFormat(uRL.openStream());
            node.setLocalScale(0.0025f);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.player = new Vehicle("Player Node", (Spatial)node);
        this.player.setAcceleration(15.0f);
        this.player.setBraking(15.0f);
        this.player.setTurnSpeed(2.5f);
        this.player.setWeight(25.0f);
        this.player.setMaxSpeed(25.0f);
        this.player.setMinSpeed(15.0f);
        this.player.setLocalTranslation(new Vector3f(100.0f, 0.0f, 100.0f));
        this.scene.attachChild((Spatial)this.player);
        this.scene.updateGeometricState(0.0f, true);
        this.agl = ((BoundingBox)this.player.getWorldBound()).yExtent;
        this.player.setRenderQueueMode(2);
    }

    private void buildEnvironment() {
        this.fence = new ForceFieldFence("fence");
        this.fence.setLocalScale(5.0f);
        this.fence.setLocalTranslation(new Vector3f(25.0f, this.tb.getHeight(25.0f, 25.0f) + 10.0f, 25.0f));
        this.scene.attachChild((Spatial)this.fence);
    }

    private void buildLighting() {
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f));
        directionalLight.setDirection(new Vector3f(1.0f, -1.0f, 0.0f));
        directionalLight.setShadowCaster(true);
        directionalLight.setEnabled(true);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.setGlobalAmbient(new ColorRGBA(0.2f, 0.2f, 0.2f, 1.0f));
        lightState.attach((Light)directionalLight);
        this.scene.setRenderState((RenderState)lightState);
    }

    private void buildTerrain() {
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(64, 1.0f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0575f, 4.0f);
        this.tb = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        this.tb.setModelBound((BoundingVolume)new BoundingBox());
        this.tb.updateModelBound();
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)midPointHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(32);
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.tb.setRenderState((RenderState)textureState);
        this.tb.setDetailTexture(1, 16);
        this.tb.setRenderQueueMode(2);
        this.scene.attachChild((Spatial)this.tb);
    }

    private void buildSkyBox() {
        this.skybox = new Skybox("skybox", 10.0f, 10.0f, 10.0f);
        Texture texture = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)2, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/south.jpg"), (int)2, (int)1);
        Texture texture3 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/east.jpg"), (int)2, (int)1);
        Texture texture4 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/west.jpg"), (int)2, (int)1);
        Texture texture5 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/top.jpg"), (int)2, (int)1);
        Texture texture6 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/bottom.jpg"), (int)2, (int)1);
        this.skybox.setTexture(0, texture);
        this.skybox.setTexture(3, texture4);
        this.skybox.setTexture(1, texture2);
        this.skybox.setTexture(2, texture3);
        this.skybox.setTexture(4, texture5);
        this.skybox.setTexture(5, texture6);
        this.skybox.preloadTextures();
        this.skybox.updateRenderState();
    }

    private void buildChaseCamera() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("maxRollOut", "6");
        hashMap.put("minRollOut", "3");
        hashMap.put("maxAscent", "0.7853982");
        hashMap.put("sphereCoords", (String)new Vector3f(5.0f, 0.0f, 0.5235988f));
        hashMap.put("dampingK", "4");
        hashMap.put("springK", "9");
        this.chaser = new ChaseCamera(this.cam, (Spatial)this.player, hashMap);
        this.chaser.setMaxDistance(8.0f);
        this.chaser.setMinDistance(2.0f);
    }

    private void buildInput() {
        this.input = new FlagRushHandler(this.player, this.properties.getRenderer());
    }

    protected void reinit() {
        this.display.recreateWindow(this.width, this.height, this.depth, this.freq, this.fullscreen);
    }

    protected void quit() {
        super.quit();
        System.exit(0);
    }

    protected void cleanup() {
    }
}

