/*
 * Decompiled with CFR 0.152.
 */
package jmetest.game.state;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.game.state.CameraGameState;
import com.jmex.game.state.GameStateManager;
import java.net.URL;

public class IngameState
extends CameraGameState {
    private InputHandler input;

    public IngameState(String string) {
        super(string);
        this.cam.setLocation(new Vector3f(0.0f, 10.0f, 0.0f));
        this.cam.update();
        this.initInput();
        Quad quad = new Quad("Quad", 200.0f, 200.0f);
        quad.setModelBound((BoundingVolume)new BoundingBox());
        quad.updateModelBound();
        quad.setLocalRotation(new Quaternion(new float[]{1.5707964f, 0.0f, 0.0f}));
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)IngameState.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        textureState.setEnabled(true);
        quad.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)quad);
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
    }

    public void onActivate() {
        DisplaySystem.getDisplaySystem().setTitle("Test Game State System - Ingame State");
        super.onActivate();
    }

    private void initInput() {
        this.input = new FirstPersonHandler(this.cam, 10.0f, 1.0f);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void stateUpdate(float f) {
        this.input.update(f);
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit", false)) {
            GameStateManager.getInstance().activateChildNamed("menu");
            GameStateManager.getInstance().detachChild("ingame");
        }
    }
}

