/*
 * Decompiled with CFR 0.152.
 */
package jmetest.game.state;

import com.jme.app.AbstractGame;
import com.jme.app.BaseGame;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jme.util.Timer;
import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateManager;
import java.util.logging.Level;
import jmetest.game.state.MenuState;

public class TestGameStateSystem
extends BaseGame {
    private static AbstractGame instance;
    private Timer timer;
    private float tpf;

    protected final void update(float f) {
        this.timer.update();
        this.tpf = this.timer.getTimePerFrame();
        GameStateManager.getInstance().update(this.tpf);
    }

    protected final void render(float f) {
        this.display.getRenderer().clearBuffers();
        GameStateManager.getInstance().render(this.tpf);
    }

    protected final void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.timer = Timer.getTimer();
    }

    protected final void initGame() {
        instance = this;
        this.display.setTitle("Test Game State System");
        GameStateManager.create();
        MenuState menuState = new MenuState("menu");
        menuState.setActive(true);
        GameStateManager.getInstance().attachChild((GameState)menuState);
    }

    protected void reinit() {
    }

    protected void cleanup() {
        LoggingSystem.getLogger().log(Level.INFO, "Cleaning up resources.");
        GameStateManager.getInstance().cleanup();
        KeyInput.destroyIfInitalized();
        MouseInput.destroyIfInitalized();
        JoystickInput.destroyIfInitalized();
    }

    public static void main(String[] stringArray) {
        TestGameStateSystem testGameStateSystem = new TestGameStateSystem();
        testGameStateSystem.setDialogBehaviour(2);
        testGameStateSystem.start();
    }

    public static void exit() {
        instance.finish();
    }
}

