/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input;

import com.jme.app.SimpleGame;
import com.jme.input.AbsoluteMouse;
import com.jme.input.InputHandler;
import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.joystick.JoystickInput;
import com.jme.input.util.TwoButtonAxis;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.awt.swingui.JMEAction;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Iterator;

public class TestInputHandler
extends SimpleGame {
    private Text text1;
    private Text text2;
    private AbsoluteMouse cursor;

    public static void main(String[] stringArray) {
        JoystickInput.setProvider((String)"LWJGL");
        TestInputHandler testInputHandler = new TestInputHandler();
        testInputHandler.setDialogBehaviour(2);
        testInputHandler.start();
    }

    protected void simpleInitGame() {
        Object object2;
        this.lightState.setEnabled(false);
        this.text1 = Text.createDefaultTextLabel((String)"Text Label", (String)"Testing InputHandler");
        this.text1.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        this.rootNode.attachChild((Spatial)this.text1);
        this.text2 = Text.createDefaultTextLabel((String)"Text Label", (String)"Testing InputHandler");
        this.text2.setLocalTranslation(new Vector3f(1.0f, 100.0f, 0.0f));
        this.rootNode.attachChild((Spatial)this.text2);
        this.display.getRenderer().setBackgroundColor(ColorRGBA.blue);
        this.cursor = new AbsoluteMouse("Mouse Cursor", this.display.getWidth(), this.display.getHeight());
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestInputHandler.class.getClassLoader().getResource("jmetest/data/cursor/cursor1.PNG"), (int)2, (int)1));
        this.cursor.setRenderState((RenderState)textureState);
        this.cursor.setRenderState(this.text1.getRenderState(0));
        this.cursor.registerWithInputHandler(this.input);
        this.rootNode.attachChild((Spatial)this.cursor);
        System.out.println("Found devices:");
        for (Object object2 : InputHandler.getDevices()) {
            System.out.println(object2);
        }
        Iterator iterator = new InputAction(){

            public void performAction(InputActionEvent inputActionEvent) {
                String string = !inputActionEvent.getTriggerAllowsRepeats() ? (inputActionEvent.getTriggerPressed() ? "pressed" : "released") : "down";
                TestInputHandler.this.text1.print(inputActionEvent.getTriggerDevice() + " " + inputActionEvent.getTriggerName() + " (" + inputActionEvent.getTriggerIndex() + ":" + inputActionEvent.getTriggerCharacter() + ") " + string + " on " + TestInputHandler.this.timer.getTime());
            }
        };
        this.input.addAction(iterator, "ALL DEVICES", Integer.MIN_VALUE, -1, false);
        this.input.addAction(iterator, "ALL DEVICES", 1, -1, true);
        object2 = new InputAction(){

            public void performAction(InputActionEvent inputActionEvent) {
                TestInputHandler.this.text2.print(inputActionEvent.getTriggerDevice() + " " + inputActionEvent.getTriggerName() + " " + "moved to " + inputActionEvent.getTriggerPosition() + " by " + inputActionEvent.getTriggerDelta());
            }
        };
        TwoButtonAxis twoButtonAxis = new TwoButtonAxis("left_right");
        this.input.addAction((InputActionInterface)twoButtonAxis.getDecreaseAction(), "keyboard", 30, -1, true);
        this.input.addAction((InputActionInterface)twoButtonAxis.getIncreaseAction(), "keyboard", 32, -1, true);
        this.input.addAction((InputActionInterface)object2, twoButtonAxis.getDeviceName(), -1, twoButtonAxis.getIndex(), false);
        final InputHandler inputHandler = new InputHandler();
        this.input.addToAttachedHandlers(inputHandler);
        inputHandler.addAction((InputActionInterface)new InputAction(){

            public void performAction(InputActionEvent inputActionEvent) {
                System.out.println("sub-handler: " + inputActionEvent.getTriggerCharacter());
            }
        }, "ALL DEVICES", Integer.MIN_VALUE, Integer.MIN_VALUE, false);
        inputHandler.setEnabled(false);
        this.input.addAction((InputActionInterface)new InputAction(){

            public void performAction(InputActionEvent inputActionEvent) {
                if (inputActionEvent.getTriggerPressed()) {
                    inputHandler.setEnabled(!inputHandler.isEnabled());
                }
            }
        }, "keyboard", 57, -1, false);
        this.input.addAction((InputActionInterface)object2, "ALL DEVICES", -1, Integer.MIN_VALUE, false);
        JMEAction jMEAction = new JMEAction("test", this.input){

            public void performAction(InputActionEvent inputActionEvent) {
                System.out.println("invoked: " + inputActionEvent.getTriggerData());
            }
        };
        jMEAction.actionPerformed(null);
        jMEAction.actionPerformed(new ActionEvent((Object)this, 1, ""));
    }

    protected void cleanup() {
        super.cleanup();
        if (this.input != null) {
            this.input.clearActions();
        }
    }
}

