/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input;

import com.jme.app.BaseGame;
import com.jme.input.InputHandler;
import com.jme.input.RelativeMouse;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import java.net.URL;
import jmetest.input.TestKeyInput;

public class TestRelativeMouse
extends BaseGame {
    private Text text;
    private Camera cam;
    private Node scene;
    private RelativeMouse mouse;
    String xString;
    String yString;
    private final InputHandler mouseInputHandler = new InputHandler();

    public static void main(String[] stringArray) {
        TestRelativeMouse testRelativeMouse = new TestRelativeMouse();
        testRelativeMouse.setDialogBehaviour(2);
        testRelativeMouse.start();
    }

    protected void update(float f) {
        this.mouseInputHandler.update(f);
        if (this.mouse.getLocalTranslation().x > 0.0f) {
            this.xString = "Right";
        } else if (this.mouse.getLocalTranslation().x < 0.0f) {
            this.xString = "Left";
        }
        if (this.mouse.getLocalTranslation().y > 0.0f) {
            this.yString = "Up";
        } else if (this.mouse.getLocalTranslation().y < 0.0f) {
            this.yString = "Down";
        }
        this.text.print("Position: " + this.xString + " , " + this.yString);
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA();
        colorRGBA.r = 0.0f;
        colorRGBA.g = 0.0f;
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f4 = new Vector3f(-1.0f, 0.0f, 0.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
    }

    protected void initGame() {
        this.mouse = new RelativeMouse("Mouse Input");
        this.mouse.registerWithInputHandler(this.mouseInputHandler);
        this.text = new Text("Text Input", "Testing Mouse");
        this.text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestKeyInput.class.getClassLoader().getResource("jmetest/data/font/font.png"), (int)2, (int)1));
        this.text.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(0);
        alphaState.setDstFunction(3);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.text.setRenderState((RenderState)alphaState);
        this.mouse.setRenderState((RenderState)alphaState);
        this.scene = new Node("Scene graph node");
        this.scene.attachChild((Spatial)this.text);
        this.scene.attachChild((Spatial)this.mouse);
        this.cam.update();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

