/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input.action;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.input.InputHandler;
import com.jme.input.Mouse;
import com.jme.input.MouseInput;
import com.jme.input.MouseInputListener;
import com.jme.input.RelativeMouse;
import com.jme.input.action.MouseInputAction;
import com.jme.input.action.MouseLook;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Point;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.net.URL;

public class TestMouseLook
extends BaseGame {
    private Node scene;
    private Camera cam;
    private Line l;
    private Point p;
    private TriMesh t;
    private TriMesh t2;
    private InputHandler input;
    private Text text;

    protected void update(float f) {
        this.input.update(1.0f);
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA();
        colorRGBA.r = 0.0f;
        colorRGBA.g = 0.0f;
        colorRGBA.b = 0.0f;
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f4 = new Vector3f(-1.0f, 0.0f, 0.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
        this.input = new InputHandler();
        RelativeMouse relativeMouse = new RelativeMouse("Mouse Input");
        relativeMouse.registerWithInputHandler(this.input);
        MouseLook mouseLook = new MouseLook((Mouse)relativeMouse, this.cam, 0.1f);
        mouseLook.setLockAxis(vector3f3);
        this.input.addAction((MouseInputAction)mouseLook);
    }

    protected void initGame() {
        Vector3f[] vector3fArray = new Vector3f[1000];
        ColorRGBA[] colorRGBAArray = new ColorRGBA[1000];
        for (int i = 0; i < 1000; ++i) {
            vector3fArray[i] = new Vector3f();
            vector3fArray[i].x = (float)Math.random() * 50.0f;
            vector3fArray[i].y = (float)Math.random() * 50.0f;
            vector3fArray[i].z = (float)Math.random() * 50.0f;
            colorRGBAArray[i] = new ColorRGBA();
            colorRGBAArray[i].r = (float)Math.random();
            colorRGBAArray[i].g = (float)Math.random();
            colorRGBAArray[i].b = (float)Math.random();
            colorRGBAArray[i].a = 1.0f;
        }
        this.l = new Line("Line Group", vector3fArray, null, colorRGBAArray, null);
        this.l.setLocalTranslation(new Vector3f(-200.0f, -25.0f, -25.0f));
        this.l.setModelBound((BoundingVolume)new BoundingSphere());
        this.l.updateModelBound();
        Vector3f[] vector3fArray2 = new Vector3f[1000];
        ColorRGBA[] colorRGBAArray2 = new ColorRGBA[1000];
        for (int i = 0; i < 1000; ++i) {
            vector3fArray2[i] = new Vector3f();
            vector3fArray2[i].x = (float)Math.random() * -100.0f - 50.0f;
            vector3fArray2[i].y = (float)Math.random() * 50.0f - 25.0f;
            vector3fArray2[i].z = (float)Math.random() * 50.0f - 25.0f;
            colorRGBAArray2[i] = new ColorRGBA();
            colorRGBAArray2[i].r = (float)Math.random();
            colorRGBAArray2[i].g = (float)Math.random();
            colorRGBAArray2[i].b = (float)Math.random();
            colorRGBAArray2[i].a = 1.0f;
        }
        this.p = new Point("Point Group", vector3fArray2, null, colorRGBAArray2, null);
        this.p.setLocalTranslation(new Vector3f(0.0f, 25.0f, 0.0f));
        this.p.setModelBound((BoundingVolume)new BoundingSphere());
        this.p.updateModelBound();
        Node node = new Node("Point Node");
        node.attachChild((Spatial)this.p);
        Vector3f[] vector3fArray3 = new Vector3f[3];
        ColorRGBA[] colorRGBAArray3 = new ColorRGBA[3];
        vector3fArray3[0] = new Vector3f();
        vector3fArray3[0].x = -50.0f;
        vector3fArray3[0].y = 0.0f;
        vector3fArray3[0].z = 0.0f;
        vector3fArray3[1] = new Vector3f();
        vector3fArray3[1].x = -50.0f;
        vector3fArray3[1].y = 25.0f;
        vector3fArray3[1].z = 25.0f;
        vector3fArray3[2] = new Vector3f();
        vector3fArray3[2].x = -50.0f;
        vector3fArray3[2].y = 25.0f;
        vector3fArray3[2].z = 0.0f;
        colorRGBAArray3[0] = new ColorRGBA();
        colorRGBAArray3[0].r = 1.0f;
        colorRGBAArray3[0].g = 0.0f;
        colorRGBAArray3[0].b = 0.0f;
        colorRGBAArray3[0].a = 1.0f;
        colorRGBAArray3[1] = new ColorRGBA();
        colorRGBAArray3[1].r = 0.0f;
        colorRGBAArray3[1].g = 1.0f;
        colorRGBAArray3[1].b = 0.0f;
        colorRGBAArray3[1].a = 1.0f;
        colorRGBAArray3[2] = new ColorRGBA();
        colorRGBAArray3[2].r = 0.0f;
        colorRGBAArray3[2].g = 0.0f;
        colorRGBAArray3[2].b = 1.0f;
        colorRGBAArray3[2].a = 1.0f;
        int[] nArray = new int[]{0, 1, 2};
        this.t = new TriMesh("Triangle 1", BufferUtils.createFloatBuffer((Vector3f[])vector3fArray3), null, BufferUtils.createFloatBuffer((ColorRGBA[])colorRGBAArray3), null, BufferUtils.createIntBuffer((int[])nArray));
        this.t.setLocalTranslation(new Vector3f(-150.0f, 0.0f, 0.0f));
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.updateModelBound();
        node.attachChild((Spatial)this.t);
        node.setLocalTranslation(new Vector3f(0.0f, -50.0f, 0.0f));
        Vector3f[] vector3fArray4 = new Vector3f[3];
        ColorRGBA[] colorRGBAArray4 = new ColorRGBA[3];
        vector3fArray4[0] = new Vector3f();
        vector3fArray4[0].x = -50.0f;
        vector3fArray4[0].y = 0.0f;
        vector3fArray4[0].z = 0.0f;
        vector3fArray4[1] = new Vector3f();
        vector3fArray4[1].x = -50.0f;
        vector3fArray4[1].y = 25.0f;
        vector3fArray4[1].z = 25.0f;
        vector3fArray4[2] = new Vector3f();
        vector3fArray4[2].x = -50.0f;
        vector3fArray4[2].y = 25.0f;
        vector3fArray4[2].z = 0.0f;
        colorRGBAArray4[0] = new ColorRGBA();
        colorRGBAArray4[0].r = 1.0f;
        colorRGBAArray4[0].g = 0.0f;
        colorRGBAArray4[0].b = 0.0f;
        colorRGBAArray4[0].a = 1.0f;
        colorRGBAArray4[1] = new ColorRGBA();
        colorRGBAArray4[1].r = 0.0f;
        colorRGBAArray4[1].g = 1.0f;
        colorRGBAArray4[1].b = 0.0f;
        colorRGBAArray4[1].a = 1.0f;
        colorRGBAArray4[2] = new ColorRGBA();
        colorRGBAArray4[2].r = 0.0f;
        colorRGBAArray4[2].g = 0.0f;
        colorRGBAArray4[2].b = 1.0f;
        colorRGBAArray4[2].a = 1.0f;
        int[] nArray2 = new int[]{0, 1, 2};
        this.t2 = new TriMesh("Triangle 2", BufferUtils.createFloatBuffer((Vector3f[])vector3fArray4), null, BufferUtils.createFloatBuffer((ColorRGBA[])colorRGBAArray4), null, BufferUtils.createIntBuffer((int[])nArray2));
        this.t2.setLocalTranslation(new Vector3f(150.0f, 0.0f, 0.0f));
        this.t2.setModelBound((BoundingVolume)new BoundingSphere());
        this.t2.updateModelBound();
        this.scene = new Node("Scene graph Node");
        this.scene.attachChild((Spatial)this.l);
        this.scene.attachChild((Spatial)node);
        this.scene.attachChild((Spatial)this.t2);
        this.cam.update();
        this.text = new Text("Text Label", "");
        this.text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestMouseLook.class.getClassLoader().getResource("jmetest/data/font/font.png"), (int)2, (int)1));
        this.text.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.text.setRenderState((RenderState)alphaState);
        this.scene.attachChild((Spatial)this.text);
        this.scene.updateRenderState();
        MouseInput.get().addListener(new MouseInputListener(){

            public void onButton(int n, boolean bl, int n2, int n3) {
                TestMouseLook.this.text.print("button " + n + " " + (bl ? "pressed" : "released"));
            }

            public void onWheel(int n, int n2, int n3) {
                TestMouseLook.this.text.print("wheel scrolled " + n);
            }

            public void onMove(int n, int n2, int n3, int n4) {
                TestMouseLook.this.text.print("mouse moved by (" + n + ";" + n2 + ")");
            }
        });
        this.scene.updateGeometricState(0.0f, true);
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }

    public static void main(String[] stringArray) {
        TestMouseLook testMouseLook = new TestMouseLook();
        testMouseLook.setDialogBehaviour(2);
        testMouseLook.start();
    }
}

