/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input.controls;

import com.jme.image.Texture;
import com.jme.input.controls.Binding;
import com.jme.input.controls.GameControl;
import com.jme.input.controls.GameControlManager;
import com.jme.input.controls.binding.KeyboardBinding;
import com.jme.input.controls.controller.ActionChangeController;
import com.jme.input.controls.controller.Axis;
import com.jme.input.controls.controller.ControlChangeListener;
import com.jme.input.controls.controller.RotationController;
import com.jme.input.controls.controller.ThrottleController;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.game.StandardGame;
import com.jmex.game.state.DebugGameState;
import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateManager;
import java.net.URL;
import jmetest.input.controls.TestSwingControlEditor;

public class TestControls {
    public static void main(String[] stringArray) throws Exception {
        final StandardGame standardGame = new StandardGame("Test Controls");
        standardGame.start();
        DebugGameState debugGameState = new DebugGameState(false);
        GameStateManager.getInstance().attachChild((GameState)debugGameState);
        debugGameState.setActive(true);
        Box box = new Box("Test Node", new Vector3f(), 5.0f, 5.0f, 5.0f);
        debugGameState.getRootNode().attachChild((Spatial)box);
        TextureState textureState = standardGame.getDisplay().getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestSwingControlEditor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        box.setRenderState((RenderState)textureState);
        box.updateRenderState();
        debugGameState.getRootNode().attachChild((Spatial)box);
        GameControlManager gameControlManager = new GameControlManager();
        GameControl gameControl = gameControlManager.addControl("Forward");
        gameControl.addBinding((Binding)new KeyboardBinding(17));
        GameControl gameControl2 = gameControlManager.addControl("Backward");
        gameControl2.addBinding((Binding)new KeyboardBinding(31));
        GameControl gameControl3 = gameControlManager.addControl("Rotate Left");
        gameControl3.addBinding((Binding)new KeyboardBinding(30));
        GameControl gameControl4 = gameControlManager.addControl("Rotate Right");
        gameControl4.addBinding((Binding)new KeyboardBinding(32));
        GameControl gameControl5 = gameControlManager.addControl("Exit");
        gameControl5.addBinding((Binding)new KeyboardBinding(1));
        ThrottleController throttleController = new ThrottleController((Spatial)box, gameControl, 1.0f, gameControl2, -1.0f, 0.05f, 0.5f, 1.0f, false, Axis.Z);
        debugGameState.getRootNode().addController((Controller)throttleController);
        RotationController rotationController = new RotationController((Spatial)box, gameControl3, gameControl4, 0.2f, Axis.Y);
        debugGameState.getRootNode().addController((Controller)rotationController);
        ActionChangeController actionChangeController = new ActionChangeController(gameControl5, new ControlChangeListener(){

            public void changed(GameControl gameControl, float f, float f2, float f3) {
                if (f2 == 1.0f) {
                    standardGame.shutdown();
                }
            }
        });
        debugGameState.getRootNode().addController((Controller)actionChangeController);
    }
}

