/*
 * Decompiled with CFR 0.152.
 */
package jmetest.input.controls;

import com.jme.image.Texture;
import com.jme.input.MouseInput;
import com.jme.input.controls.Binding;
import com.jme.input.controls.GameControl;
import com.jme.input.controls.GameControlManager;
import com.jme.input.controls.controller.ActionChangeController;
import com.jme.input.controls.controller.ActionController;
import com.jme.input.controls.controller.ActionRepeatController;
import com.jme.input.controls.controller.Axis;
import com.jme.input.controls.controller.CameraController;
import com.jme.input.controls.controller.ControlChangeListener;
import com.jme.input.controls.controller.GameControlAction;
import com.jme.input.controls.controller.RotationController;
import com.jme.input.controls.controller.ThrottleController;
import com.jme.input.controls.controller.camera.CameraPerspective;
import com.jme.input.controls.controller.camera.FixedCameraPerspective;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.GameSettings;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.TextureManager;
import com.jmex.awt.swingui.JMEDesktopState;
import com.jmex.editors.swing.controls.GameControlEditor;
import com.jmex.game.StandardGame;
import com.jmex.game.state.BasicGameState;
import com.jmex.game.state.GameState;
import com.jmex.game.state.GameStateManager;
import com.jmex.game.state.TextGameState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class TestSwingControlEditor {
    private static GameControlManager manager;

    public static void main(String[] stringArray) throws Exception {
        final StandardGame standardGame = new StandardGame("TestSwingControlEditor");
        standardGame.start();
        manager = GameControlManager.load((GameSettings)standardGame.getSettings());
        if (manager == null) {
            manager = new GameControlManager();
            manager.addControl("Forward");
            manager.addControl("Backward");
            manager.addControl("Rotate Left");
            manager.addControl("Rotate Right");
            manager.addControl("Jump");
            manager.addControl("Crouch");
            manager.addControl("Run");
            manager.addControl("Fire");
            manager.addControl("Cycle Camera");
        }
        final JMEDesktopState jMEDesktopState = new JMEDesktopState();
        GameStateManager.getInstance().attachChild((GameState)jMEDesktopState);
        jMEDesktopState.setActive(true);
        BasicGameState basicGameState = new BasicGameState("Basic");
        GameStateManager.getInstance().attachChild((GameState)basicGameState);
        basicGameState.setActive(true);
        Box box = new Box("Test Node", new Vector3f(), 5.0f, 5.0f, 5.0f);
        basicGameState.getRootNode().attachChild((Spatial)box);
        TextureState textureState = standardGame.getDisplay().getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestSwingControlEditor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        texture.setWrap(3);
        textureState.setTexture(texture);
        box.setRenderState((RenderState)textureState);
        box.updateRenderState();
        final ThrottleController throttleController = new ThrottleController((Spatial)box, manager.getControl("Forward"), 1.0f, manager.getControl("Backward"), -1.0f, 0.05f, 0.5f, 1.0f, false, Axis.Z);
        basicGameState.getRootNode().addController((Controller)throttleController);
        final TextGameState textGameState = new TextGameState("Throttle: 0");
        GameStateManager.getInstance().attachChild((GameState)textGameState);
        textGameState.setActive(true);
        Controller controller = new Controller(){

            public void update(float f) {
                textGameState.setText(throttleController.getCurrentThrottle() + ", " + throttleController.getThrust());
            }
        };
        basicGameState.getRootNode().addController(controller);
        basicGameState.getRootNode().addController((Controller)new RotationController((Spatial)box, manager.getControl("Rotate Left"), manager.getControl("Rotate Right"), 0.2f, Axis.Y));
        GameControlAction gameControlAction = new GameControlAction(){

            public void pressed(GameControl gameControl, float f) {
                System.out.println("Pressed: " + gameControl.getName() + ", elapsed: " + f);
            }

            public void released(GameControl gameControl, float f) {
                System.out.println("Released: " + gameControl.getName() + " after " + f);
            }
        };
        basicGameState.getRootNode().addController((Controller)new ActionController(manager.getControl("Jump"), gameControlAction));
        basicGameState.getRootNode().addController((Controller)new ActionController(manager.getControl("Crouch"), gameControlAction));
        ControlChangeListener controlChangeListener = new ControlChangeListener(){

            public void changed(GameControl gameControl, float f, float f2, float f3) {
                System.out.println("Changed: " + gameControl.getName() + ", " + f + ", " + f2 + ", " + f3);
            }
        };
        basicGameState.getRootNode().addController((Controller)new ActionChangeController(manager.getControl("Run"), controlChangeListener));
        Runnable runnable = new Runnable(){
            private long lastRun;

            public void run() {
                if (this.lastRun == 0L) {
                    this.lastRun = System.currentTimeMillis();
                }
                System.out.println("KABOOM: " + (System.currentTimeMillis() - this.lastRun));
                this.lastRun = System.currentTimeMillis();
            }
        };
        basicGameState.getRootNode().addController((Controller)new ActionRepeatController(manager.getControl("Fire"), 1000L, runnable));
        CameraController cameraController = new CameraController((Spatial)box, standardGame.getCamera(), manager.getControl("Cycle Camera"));
        cameraController.addPerspective(new CameraPerspective(){
            private Camera camera;
            private Vector3f location;
            private Vector3f dir;
            private Vector3f left;
            private Vector3f up;

            public void update(Camera camera, Spatial spatial, float f) {
                if (this.camera == null) {
                    this.camera = camera;
                    try {
                        this.location = (Vector3f)camera.getLocation().clone();
                        this.dir = (Vector3f)camera.getDirection().clone();
                        this.left = (Vector3f)camera.getLeft().clone();
                        this.up = (Vector3f)camera.getUp().clone();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (!camera.getLocation().equals((Object)this.location)) {
                    System.out.println("Changing from: " + camera.getDirection() + " to " + this.dir);
                    System.out.println("Another: " + camera.getUp() + "\nAnd: " + camera.getLeft());
                    camera.setLocation(this.location);
                    camera.setDirection(this.dir);
                    camera.setLeft(this.left);
                    camera.setUp(this.up);
                }
            }

            public void setActive(Camera camera, Spatial spatial, boolean bl) {
            }
        });
        cameraController.addPerspective((CameraPerspective)new FixedCameraPerspective(new Vector3f(0.0f, 0.0f, -15.0f)));
        basicGameState.getRootNode().addController((Controller)cameraController);
        GameTaskQueueManager.getManager().update((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                JInternalFrame jInternalFrame = new JInternalFrame();
                jInternalFrame.setTitle("Configure Controls");
                Container container = jInternalFrame.getContentPane();
                container.setLayout(new BorderLayout());
                final GameControlEditor gameControlEditor = new GameControlEditor(manager, 2);
                container.add((Component)gameControlEditor, "Center");
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new FlowLayout());
                JButton jButton = new JButton("Close");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        standardGame.finish();
                    }
                });
                jPanel.add(jButton);
                jButton = new JButton("Clear");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        gameControlEditor.clear();
                    }
                });
                jPanel.add(jButton);
                jButton = new JButton("Reset");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        gameControlEditor.reset();
                    }
                });
                jPanel.add(jButton);
                jButton = new JButton("Apply");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        gameControlEditor.apply();
                        GameControlManager.save((GameControlManager)manager, (GameSettings)standardGame.getSettings());
                        for (GameControl gameControl : manager.getControls()) {
                            System.out.println(gameControl.getName() + ":");
                            for (Binding binding : gameControl.getBindings()) {
                                System.out.println("\t" + binding.getName());
                            }
                            System.out.println("-------");
                        }
                    }
                });
                jPanel.add(jButton);
                container.add((Component)jPanel, "South");
                jInternalFrame.pack();
                jInternalFrame.setLocation(200, 100);
                jInternalFrame.setVisible(true);
                jMEDesktopState.getDesktop().getJDesktop().add(jInternalFrame);
                MouseInput.get().setCursorVisible(true);
                return null;
            }
        });
    }
}

