/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.input.MouseInput;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.MouseInputAction;
import com.jme.intersection.BoundingPickResults;
import com.jme.intersection.PickResults;
import com.jme.math.Ray;
import com.jme.renderer.Camera;
import com.jme.scene.Node;
import com.jme.scene.Text;

public class MousePick
extends MouseInputAction {
    private Camera camera;
    private Node scene;
    private float shotTime = 0.0f;
    private int hits = 0;
    private int shots = 0;
    private Text text;
    private String hitItems;

    public MousePick(Camera camera, Node node, Text text) {
        this.camera = camera;
        this.scene = node;
        this.text = text;
    }

    public void performAction(InputActionEvent inputActionEvent) {
        this.shotTime += inputActionEvent.getTime();
        if (MouseInput.get().isButtonDown(0) && this.shotTime > 0.1f) {
            this.shotTime = 0.0f;
            Ray ray = new Ray(this.camera.getLocation(), this.camera.getDirection());
            BoundingPickResults boundingPickResults = new BoundingPickResults();
            boundingPickResults.setCheckDistance(false);
            this.scene.findPick(ray, (PickResults)boundingPickResults);
            this.hits += boundingPickResults.getNumber();
            this.hitItems = "";
            if (boundingPickResults.getNumber() > 0) {
                for (int i = 0; i < boundingPickResults.getNumber(); ++i) {
                    this.hitItems = this.hitItems + boundingPickResults.getPickData(i).getTargetMesh().getParentGeom().getName() + " " + boundingPickResults.getPickData(i).getDistance();
                    if (i == boundingPickResults.getNumber() - 1) continue;
                    this.hitItems = this.hitItems + ", ";
                }
            }
            ++this.shots;
            boundingPickResults.clear();
            this.text.print("Hits: " + this.hits + " Shots: " + this.shots + " : " + this.hitItems);
        }
    }
}

