/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.animation.SpatialTransformer;
import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.CollisionTreeManager;
import com.jme.intersection.CollisionData;
import com.jme.intersection.CollisionResults;
import com.jme.intersection.TriangleCollisionResults;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.PQTorus;
import com.jme.scene.shape.Sphere;
import com.jme.util.geom.BufferUtils;
import java.nio.FloatBuffer;

public class TestCollisionTree
extends SimpleGame {
    ColorRGBA[] colorSpread = new ColorRGBA[]{ColorRGBA.white, ColorRGBA.green, ColorRGBA.gray};
    TriMesh s;
    TriMesh r;
    Node n;
    Node m;
    CollisionResults results;
    CollisionData oldData;
    int count = 0;

    public static void main(String[] stringArray) {
        TestCollisionTree testCollisionTree = new TestCollisionTree();
        testCollisionTree.setDialogBehaviour(2);
        testCollisionTree.start();
    }

    protected void simpleInitGame() {
        ColorRGBA colorRGBA;
        int n;
        int n2;
        FloatBuffer floatBuffer;
        int n3;
        CollisionTreeManager.getInstance().setTreeType(1);
        this.results = new TriangleCollisionResults();
        this.s = new Sphere("sphere", 10, 10, 1.0f);
        this.s.setSolidColor(ColorRGBA.white);
        this.s.setModelBound((BoundingVolume)new BoundingBox());
        this.s.updateModelBound();
        this.n = new Node("sphere node");
        this.r = new PQTorus("tort", 5.0f, 4.0f, 2.0f, 0.5f, 128, 16);
        this.r.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.r.setSolidColor(ColorRGBA.white);
        this.r.setModelBound((BoundingVolume)new BoundingBox());
        this.r.updateModelBound();
        this.m = new Node("tort node");
        SpatialTransformer spatialTransformer = new SpatialTransformer(1);
        spatialTransformer.setRepeatType(2);
        spatialTransformer.setObject((Spatial)this.m, 0, -1);
        spatialTransformer.setPosition(0, 0.0f, new Vector3f(10.0f, 10.0f, 0.0f));
        spatialTransformer.setPosition(0, 4.0f, new Vector3f(-10.0f, -10.0f, 0.0f));
        spatialTransformer.interpolateMissing();
        this.r.addController((Controller)spatialTransformer);
        for (n3 = 0; n3 < this.r.getBatchCount(); ++n3) {
            floatBuffer = this.r.getBatch(n3).getColorBuffer();
            floatBuffer.clear();
            n2 = floatBuffer.capacity();
            for (n = 0; n < n2; n += 4) {
                colorRGBA = this.colorSpread[n % 3];
                floatBuffer.put(colorRGBA.r).put(colorRGBA.g).put(colorRGBA.b).put(colorRGBA.a);
            }
            floatBuffer.flip();
        }
        for (n3 = 0; n3 < this.s.getBatchCount(); ++n3) {
            floatBuffer = this.s.getBatch(n3).getColorBuffer();
            floatBuffer.clear();
            n2 = floatBuffer.capacity();
            for (n = 0; n < n2; n += 4) {
                colorRGBA = this.colorSpread[n % 3];
                floatBuffer.put(colorRGBA.r).put(colorRGBA.g).put(colorRGBA.b).put(colorRGBA.a);
            }
            floatBuffer.flip();
        }
        this.n.attachChild((Spatial)this.r);
        this.m.attachChild((Spatial)this.s);
        this.rootNode.attachChild((Spatial)this.n);
        this.rootNode.attachChild((Spatial)this.m);
        this.lightState.detachAll();
        this.lightState.setEnabled(false);
    }

    protected void simpleUpdate() {
        int n;
        ++this.count;
        if (this.count < 5) {
            return;
        }
        this.count = 0;
        int[] nArray = new int[3];
        if (this.oldData != null) {
            FloatBuffer floatBuffer;
            int n2;
            if (this.oldData.getSourceBatchId() == 1) {
                System.out.println("1");
            }
            for (n = 0; n < this.oldData.getSourceTris().size(); ++n) {
                n2 = (Integer)this.oldData.getSourceTris().get(n);
                this.s.getTriangle(this.oldData.getSourceBatchId(), n2, nArray);
                floatBuffer = this.s.getColorBuffer(this.oldData.getSourceBatchId());
                BufferUtils.setInBuffer((ColorRGBA)this.colorSpread[nArray[0] % 3], (FloatBuffer)floatBuffer, (int)nArray[0]);
                BufferUtils.setInBuffer((ColorRGBA)this.colorSpread[nArray[1] % 3], (FloatBuffer)floatBuffer, (int)nArray[1]);
                BufferUtils.setInBuffer((ColorRGBA)this.colorSpread[nArray[2] % 3], (FloatBuffer)floatBuffer, (int)nArray[2]);
            }
            for (n = 0; n < this.oldData.getTargetTris().size(); ++n) {
                n2 = (Integer)this.oldData.getTargetTris().get(n);
                this.r.getTriangle(this.oldData.getTargetBatchId(), n2, nArray);
                floatBuffer = this.r.getColorBuffer(this.oldData.getTargetBatchId());
                BufferUtils.setInBuffer((ColorRGBA)this.colorSpread[nArray[0] % 3], (FloatBuffer)floatBuffer, (int)nArray[0]);
                BufferUtils.setInBuffer((ColorRGBA)this.colorSpread[nArray[1] % 3], (FloatBuffer)floatBuffer, (int)nArray[1]);
                BufferUtils.setInBuffer((ColorRGBA)this.colorSpread[nArray[2] % 3], (FloatBuffer)floatBuffer, (int)nArray[2]);
            }
        }
        this.results.clear();
        this.m.findCollisions((Spatial)this.n, this.results);
        if (this.results.getNumber() > 0) {
            this.oldData = this.results.getCollisionData(0);
            for (n = 0; n < this.oldData.getSourceTris().size(); ++n) {
                FloatBuffer floatBuffer = this.s.getColorBuffer(this.oldData.getSourceBatchId());
                int n3 = (Integer)this.oldData.getSourceTris().get(n);
                this.s.getTriangle(this.oldData.getSourceBatchId(), n3, nArray);
                BufferUtils.setInBuffer((ColorRGBA)ColorRGBA.red, (FloatBuffer)floatBuffer, (int)nArray[0]);
                BufferUtils.setInBuffer((ColorRGBA)ColorRGBA.red, (FloatBuffer)floatBuffer, (int)nArray[1]);
                BufferUtils.setInBuffer((ColorRGBA)ColorRGBA.red, (FloatBuffer)floatBuffer, (int)nArray[2]);
            }
            for (n = 0; n < this.oldData.getTargetTris().size(); ++n) {
                int n4 = (Integer)this.oldData.getTargetTris().get(n);
                FloatBuffer floatBuffer = this.r.getColorBuffer(this.oldData.getTargetBatchId());
                this.r.getTriangle(this.oldData.getTargetBatchId(), n4, nArray);
                BufferUtils.setInBuffer((ColorRGBA)ColorRGBA.blue, (FloatBuffer)floatBuffer, (int)nArray[0]);
                BufferUtils.setInBuffer((ColorRGBA)ColorRGBA.blue, (FloatBuffer)floatBuffer, (int)nArray[1]);
                BufferUtils.setInBuffer((ColorRGBA)ColorRGBA.blue, (FloatBuffer)floatBuffer, (int)nArray[2]);
            }
        }
    }
}

