/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Capsule;
import com.jme.scene.shape.Teapot;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.logging.Level;

public class TestOBB
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    private Spatial s;
    private Box t;
    private float tInc = -40.0f;
    private Capsule c;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestOBB testOBB = new TestOBB();
        testOBB.setDialogBehaviour(2);
        testOBB.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.t.setLocalRotation(this.rotQuat);
        this.t.getLocalTranslation().y += this.tInc * this.timer.getTimePerFrame();
        if (this.t.getLocalTranslation().y > 40.0f) {
            this.t.getLocalTranslation().y = 40.0f;
            this.tInc *= -1.0f;
        } else if (this.t.getLocalTranslation().y < -40.0f) {
            this.t.getLocalTranslation().y = -40.0f;
            this.tInc *= -1.0f;
        }
        if (this.t.hasCollision(this.s, false)) {
            System.out.println("hasCollision reports true");
        }
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME - Oriented Bounding Box");
        this.s = new Teapot("Teapot");
        this.rootNode.attachChild(this.s);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(2.0f, new Vector3f(1.0f, 23.0f, 1.0f));
        this.s.setLocalRotation(quaternion);
        this.s.setLocalTranslation(new Vector3f(10.0f, 2.0f, 1.0f));
        this.s.setModelBound((BoundingVolume)new OrientedBoundingBox());
        this.s.updateModelBound();
        this.t = new Box("box", new Vector3f(0.0f, 0.0f, 0.0f), 10.0f, 2.0f, 2.0f);
        this.t.getBatch(0).translatePoints(2.5f, 10.0f, 1.0f);
        this.t.setModelBound((BoundingVolume)new OrientedBoundingBox());
        this.t.setLocalTranslation(new Vector3f(15.0f, 0.0f, 10.0f));
        this.t.setLocalScale(new Vector3f(1.0f, 2.0f, 1.0f));
        this.t.updateModelBound();
        this.rootNode.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestOBB.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
        this.rootNode.updateGeometricState(0.0f, true);
        System.out.println(this.rootNode.getWorldBound());
    }
}

