/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.CollisionTreeManager;
import com.jme.intersection.PickData;
import com.jme.intersection.PickResults;
import com.jme.intersection.TrianglePickResults;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Point;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Dodecahedron;
import com.jme.scene.shape.Octahedron;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.XMLparser.Converters.ObjToJme;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.MidPointHeightMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class TestObjectWalking
extends SimpleGame {
    Node pickNode;
    private Line walkSelection;
    private Point pointWalk;
    private Vector3f oldCamLoc;
    TrianglePickResults camResults = new TrianglePickResults(){

        public void processPick() {
            int n = 0;
            for (int i = 0; i < this.getNumber(); ++i) {
                n += this.getPickData(i).getTargetTris().size();
            }
            if (this.getNumber() > 0) {
                PickData pickData = this.getPickData(0);
                ArrayList arrayList = pickData.getTargetTris();
                TriangleBatch triangleBatch = (TriangleBatch)pickData.getTargetMesh();
                if (arrayList.size() > 0) {
                    int n2 = (Integer)arrayList.get(0);
                    Vector3f[] vector3fArray = new Vector3f[3];
                    triangleBatch.getTriangle(n2, vector3fArray);
                    for (int i = 0; i < vector3fArray.length; ++i) {
                        vector3fArray[i].multLocal(triangleBatch.getParentGeom().getWorldScale());
                        triangleBatch.getParentGeom().getWorldRotation().mult(vector3fArray[i], vector3fArray[i]);
                        vector3fArray[i].addLocal(triangleBatch.getParentGeom().getWorldTranslation());
                    }
                    Vector3f vector3f = new Vector3f();
                    pickData.getRay().intersectWhere(vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3f);
                    vector3f.y += 10.0f;
                    TestObjectWalking.this.cam.getLocation().set(vector3f);
                    TestObjectWalking.this.cam.update();
                    TestObjectWalking.this.oldCamLoc.set(TestObjectWalking.this.cam.getLocation());
                    BufferUtils.setInBuffer((Vector3f)vector3f, (FloatBuffer)TestObjectWalking.this.pointWalk.getVertexBuffer(0), (int)0);
                    FloatBuffer floatBuffer = TestObjectWalking.this.walkSelection.getVertexBuffer(0);
                    BufferUtils.setInBuffer((Vector3f)vector3fArray[0], (FloatBuffer)floatBuffer, (int)0);
                    BufferUtils.setInBuffer((Vector3f)vector3fArray[1], (FloatBuffer)floatBuffer, (int)1);
                    BufferUtils.setInBuffer((Vector3f)vector3fArray[2], (FloatBuffer)floatBuffer, (int)2);
                    BufferUtils.setInBuffer((Vector3f)vector3fArray[0], (FloatBuffer)floatBuffer, (int)3);
                } else {
                    System.out.println("No triangles");
                }
            }
        }
    };
    Ray camRay = new Ray(new Vector3f(), new Vector3f(0.0f, -1.0f, 0.0f));

    public static void main(String[] stringArray) {
        TestObjectWalking testObjectWalking = new TestObjectWalking();
        testObjectWalking.setDialogBehaviour(2);
        testObjectWalking.start();
    }

    protected void simpleInitGame() {
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(0.75f, 0.75f, 0.75f, 1.0f));
        pointLight.setEnabled(true);
        pointLight.setLocation(new Vector3f(500.0f, 500.0f, 500.0f));
        this.lightState.attach((Light)pointLight);
        this.walkSelection = new Line("selected triangle", new Vector3f[4], null, new ColorRGBA[4], null);
        this.walkSelection.setSolidColor(new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f));
        this.walkSelection.setLineWidth(5.0f);
        this.walkSelection.setAntialiased(true);
        this.walkSelection.setMode(1);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setFunction(7);
        this.walkSelection.setRenderState((RenderState)zBufferState);
        this.walkSelection.setLightCombineMode(0);
        this.rootNode.attachChild((Spatial)this.walkSelection);
        this.pointWalk = new Point("selected triangle", new Vector3f[1], null, new ColorRGBA[1], null);
        this.pointWalk.setSolidColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        this.pointWalk.setPointSize(10.0f);
        this.pointWalk.setAntialiased(true);
        this.pointWalk.setRenderState((RenderState)zBufferState);
        this.pointWalk.setLightCombineMode(0);
        this.rootNode.attachChild((Spatial)this.pointWalk);
        CollisionTreeManager.getInstance().setTreeType(1);
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(128, 1.9f);
        Vector3f vector3f = new Vector3f(5.0f, 1.0f, 5.0f);
        TerrainBlock terrainBlock = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock.updateModelBound();
        CollisionTreeManager.getInstance().generateCollisionTree(1, (Spatial)terrainBlock, true);
        Box box = new Box("b", new Vector3f(0.0f, 0.0f, 0.0f), 10.0f, 10.0f, 10.0f);
        SharedMesh sharedMesh = new SharedMesh("Shared box", (TriMesh)box);
        sharedMesh.setModelBound((BoundingVolume)new BoundingBox());
        sharedMesh.updateModelBound();
        sharedMesh.setLocalTranslation(new Vector3f(100.0f, terrainBlock.getHeight(100.0f, 200.0f), 200.0f));
        SharedMesh sharedMesh2 = new SharedMesh("Shared box2", (TriMesh)box);
        sharedMesh2.setModelBound((BoundingVolume)new BoundingBox());
        sharedMesh2.updateModelBound();
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(3.0f, new Vector3f(1.0f, 0.0f, 0.0f));
        sharedMesh2.setLocalRotation(quaternion);
        sharedMesh2.setLocalTranslation(new Vector3f(150.0f, terrainBlock.getHeight(150.0f, 100.0f), 100.0f));
        Octahedron octahedron = new Octahedron("o", 10.0f);
        octahedron.setModelBound((BoundingVolume)new BoundingBox());
        octahedron.updateModelBound();
        octahedron.setLocalTranslation(new Vector3f(100.0f, terrainBlock.getHeight(100.0f, 150.0f), 150.0f));
        Dodecahedron dodecahedron = new Dodecahedron("d", 10.0f);
        Sphere sphere = new Sphere("sphere", 50, 50, 10.0f);
        SharedMesh sharedMesh3 = new SharedMesh("Shared d1", (TriMesh)dodecahedron);
        sharedMesh3.setModelBound((BoundingVolume)new BoundingBox());
        sharedMesh3.updateModelBound();
        sharedMesh3.setLocalTranslation(new Vector3f(150.0f, terrainBlock.getHeight(150.0f, 150.0f), 150.0f));
        SharedMesh sharedMesh4 = new SharedMesh("Shared d2", (TriMesh)dodecahedron);
        sharedMesh4.setModelBound((BoundingVolume)new BoundingBox());
        sharedMesh4.updateModelBound();
        sharedMesh4.setLocalTranslation(new Vector3f(150.0f, terrainBlock.getHeight(150.0f, 200.0f), 200.0f));
        Quaternion quaternion2 = new Quaternion();
        quaternion2.fromAngleAxis(2.0f, new Vector3f(1.0f, 0.0f, 1.0f));
        sharedMesh4.setLocalRotation(quaternion2);
        SharedMesh sharedMesh5 = new SharedMesh("Shared Sphere1", (TriMesh)sphere);
        sharedMesh5.setModelBound((BoundingVolume)new BoundingBox());
        sharedMesh5.updateModelBound();
        sharedMesh5.setLocalTranslation(new Vector3f(100.0f, terrainBlock.getHeight(100.0f, 50.0f), 50.0f));
        SharedMesh sharedMesh6 = new SharedMesh("Shared Sphere2", (TriMesh)sphere);
        sharedMesh6.setModelBound((BoundingVolume)new BoundingBox());
        sharedMesh6.updateModelBound();
        sharedMesh6.setLocalTranslation(new Vector3f(50.0f, terrainBlock.getHeight(50.0f, 100.0f), 100.0f));
        Sphere sphere2 = new Sphere("sphere2", 50, 50, 10.0f);
        sphere2.setModelBound((BoundingVolume)new BoundingBox());
        sphere2.updateModelBound();
        sphere2.setLocalTranslation(new Vector3f(200.0f, terrainBlock.getHeight(200.0f, 50.0f), 50.0f));
        sphere2.setLocalScale(2.0f);
        Box box2 = new Box("Bridge", new Vector3f(0.0f, 0.0f, 0.0f), 100.0f, 5.0f, 10.0f);
        box2.setModelBound((BoundingVolume)new BoundingBox());
        box2.updateModelBound();
        box2.setLocalTranslation(new Vector3f(100.0f, terrainBlock.getHeight(100.0f, 50.0f) + 5.0f, 50.0f));
        URL uRL = TestObjectWalking.class.getClassLoader().getResource("jmetest/data/model/maggie.obj");
        Spatial spatial = null;
        try {
            ObjToJme objToJme = new ObjToJme();
            objToJme.setProperty("mtllib", (Object)uRL);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
            spatial = (Spatial)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            spatial.setLocalScale(0.1f);
            spatial.setLocalTranslation(new Vector3f(100.0f, terrainBlock.getHeight(100.0f, 100.0f), 100.0f));
            Quaternion quaternion3 = new Quaternion();
            quaternion3.fromAngleAxis(0.5f, new Vector3f(0.0f, 1.0f, 0.0f));
            spatial.setLocalRotation(quaternion3);
        }
        catch (IOException iOException) {
            System.out.println("Damn exceptions!" + iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
        spatial.setModelBound((BoundingVolume)new BoundingBox());
        spatial.updateModelBound();
        this.pickNode = new Node("Pick");
        this.pickNode.attachChild(spatial);
        this.pickNode.attachChild((Spatial)terrainBlock);
        this.pickNode.attachChild((Spatial)sharedMesh);
        this.pickNode.attachChild((Spatial)sharedMesh2);
        this.pickNode.attachChild((Spatial)octahedron);
        this.pickNode.attachChild((Spatial)sharedMesh3);
        this.pickNode.attachChild((Spatial)sharedMesh4);
        this.pickNode.attachChild((Spatial)sharedMesh6);
        this.pickNode.attachChild((Spatial)sharedMesh5);
        this.pickNode.attachChild((Spatial)sphere2);
        this.pickNode.attachChild((Spatial)box2);
        this.pickNode.updateGeometricState(0.0f, true);
        this.rootNode.attachChild((Spatial)this.pickNode);
        this.camResults.setCheckDistance(true);
        this.cam.setLocation(new Vector3f(50.0f, terrainBlock.getHeight(50.0f, 50.0f) + 10.0f, 50.0f));
        this.cam.setDirection(new Vector3f(0.5f, 0.0f, 0.5f));
        this.cam.setLeft(new Vector3f(0.5f, 0.0f, -0.5f));
        this.cam.update();
        this.oldCamLoc = new Vector3f(this.cam.getLocation());
        this.pickNode.lockBounds();
        this.pickNode.lockTransforms();
    }

    protected void simpleUpdate() {
        this.camRay.getOrigin().set(this.cam.getLocation());
        this.camResults.clear();
        this.pickNode.calculatePick(this.camRay, (PickResults)this.camResults);
    }
}

