/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.AreaClodMesh;
import com.jme.scene.shape.Disk;
import com.jme.util.TextureKey;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.AseToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jmetest.renderer.loader.TestASEJmeWrite;

public class TestAutoClodMesh
extends SimpleGame {
    private Node model;
    private AreaClodMesh iNode;
    private AreaClodMesh iNode2;
    private boolean useModel = true;

    public static void main(String[] stringArray) {
        TestAutoClodMesh testAutoClodMesh = new TestAutoClodMesh();
        testAutoClodMesh.setDialogBehaviour(2);
        testAutoClodMesh.start();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("switch_models", false)) {
            this.useModel = !this.useModel;
            this.iNode.setCullMode(this.useModel ? 2 : 1);
            this.iNode2.setCullMode(this.useModel ? 1 : 2);
        }
    }

    protected void simpleInitGame() {
        KeyBindingManager.getKeyBindingManager().set("switch_models", 50);
        this.display.setTitle("Auto-Change Clod Test (using AreaClodMesh)");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 25.0f));
        this.cam.update();
        InputStream inputStream = TestASEJmeWrite.class.getClassLoader().getResourceAsStream("jmetest/data/model/Statue.ase");
        URL uRL = TestASEJmeWrite.class.getClassLoader().getResource("jmetest/data/model/");
        if (inputStream == null) {
            System.out.println("Unable to find statue file, did you include jme-test.jar in classpath?");
            System.exit(0);
        }
        AseToJme aseToJme = new AseToJme();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            TextureKey.setOverridingLocation((URL)uRL);
            aseToJme.convert(inputStream, (OutputStream)byteArrayOutputStream);
            this.model = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.model.updateGeometricState(0.0f, true);
        this.iNode = new AreaClodMesh("model", (TriMesh)new Disk("disc", 50, 50, 8.0f), null);
        this.rootNode.attachChild((Spatial)this.iNode);
        this.iNode.setCullMode(2);
        this.iNode.setModelBound((BoundingVolume)new BoundingSphere());
        this.iNode.updateModelBound();
        Spatial spatial = this.model.getChild(0);
        while (spatial instanceof Node) {
            spatial = ((Node)spatial).getChild(0);
        }
        this.iNode2 = new AreaClodMesh("model", (TriMesh)spatial, null);
        this.rootNode.attachChild((Spatial)this.iNode2);
        this.iNode2.setDistanceTolerance(0.0f);
        this.iNode2.setCullMode(1);
        this.iNode2.setModelBound((BoundingVolume)new BoundingSphere());
        this.iNode2.updateModelBound();
    }
}

