/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.image.Texture;
import com.jme.input.NodeHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.LightNode;
import com.jme.light.SpotLight;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.TextureRenderer;
import com.jme.scene.CameraNode;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.CullState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureKey;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.MilkToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jmetest.renderer.loader.TestMilkJmeWrite;

public class TestCameraMan
extends SimpleGame {
    private Node model;
    private Node monitorNode;
    private CameraNode camNode;
    private TextureRenderer tRenderer;
    private Texture fakeTex;
    private float lastRend = 1.0f;
    private float throttle = 0.033333335f;

    public static void main(String[] stringArray) {
        TestCameraMan testCameraMan = new TestCameraMan();
        testCameraMan.setDialogBehaviour(2);
        testCameraMan.start();
    }

    protected void cleanup() {
        super.cleanup();
        this.tRenderer.cleanup();
    }

    protected void simpleRender() {
        this.lastRend += this.tpf;
        if (this.lastRend > this.throttle) {
            this.tRenderer.render((Spatial)this.model, this.fakeTex);
            this.lastRend = 0.0f;
        }
    }

    protected void simpleInitGame() {
        this.cam.setLocation(new Vector3f(0.0f, 50.0f, 100.0f));
        this.cam.update();
        this.tRenderer = this.display.createTextureRenderer(256, 256, 2);
        this.camNode = new CameraNode("Camera Node", this.tRenderer.getCamera());
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 50.0f, -50.0f));
        this.camNode.updateGeometricState(0.0f, true);
        this.input = new NodeHandler((Spatial)this.camNode, 10.0f, 1.0f);
        this.display.setTitle("Camera Man");
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(1.0f, 0.0f, 0.0f));
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.attach((Light)directionalLight);
        directionalLight.setEnabled(true);
        SpotLight spotLight = new SpotLight();
        spotLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        spotLight.setAmbient(new ColorRGBA(0.75f, 0.75f, 0.75f, 1.0f));
        spotLight.setDirection(new Vector3f(0.0f, 0.0f, 1.0f));
        spotLight.setLocation(new Vector3f(0.0f, 0.0f, 0.0f));
        spotLight.setAngle(25.0f);
        spotLight.setEnabled(true);
        this.rootNode.setRenderState((RenderState)lightState);
        MilkToJme milkToJme = new MilkToJme();
        URL uRL = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/run.ms3d");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            milkToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            System.out.println("IO problem writting the file!!!");
            System.out.println(iOException.getMessage());
            System.exit(0);
        }
        URL uRL2 = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/");
        this.model = null;
        try {
            TextureKey.setOverridingLocation((URL)uRL2);
            this.model = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            System.out.println("darn exceptions:" + iOException.getMessage());
        }
        this.model.getController(0).setActive(false);
        this.rootNode.attachChild((Spatial)this.model);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        this.model.setRenderState((RenderState)cullState);
        this.lightState.detachAll();
        LightNode lightNode = new LightNode("Camera Light", this.lightState);
        lightNode.setLight((Light)spotLight);
        lightNode.setTarget((Spatial)this.model);
        MilkToJme milkToJme2 = new MilkToJme();
        URL uRL3 = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/camera.ms3d");
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        try {
            milkToJme2.convert(uRL3.openStream(), (OutputStream)byteArrayOutputStream2);
        }
        catch (IOException iOException) {
            System.out.println("IO problem writting the file!!!");
            System.out.println(iOException.getMessage());
            System.exit(0);
        }
        URL uRL4 = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/");
        Node node = null;
        try {
            TextureKey.setOverridingLocation((URL)uRL4);
            node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream2.toByteArray()));
        }
        catch (IOException iOException) {
            System.out.println("darn exceptions:" + iOException.getMessage());
        }
        this.camNode.attachChild((Spatial)node);
        this.camNode.attachChild((Spatial)lightNode);
        this.rootNode.attachChild((Spatial)this.camNode);
        this.monitorNode = new Node("Monitor Node");
        Quad quad = new Quad("Monitor");
        quad.initialize(3.0f, 3.0f);
        quad.setLocalTranslation(new Vector3f(3.75f, 52.5f, 90.0f));
        this.monitorNode.attachChild((Spatial)quad);
        Quad quad2 = new Quad("Monitor");
        quad2.initialize(3.4f, 3.4f);
        quad2.setLocalTranslation(new Vector3f(3.95f, 52.6f, 89.5f));
        this.monitorNode.attachChild((Spatial)quad2);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.monitorNode.setRenderState((RenderState)zBufferState);
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.fakeTex = new Texture();
        this.fakeTex.setRTTSource(1);
        this.tRenderer.setupTexture(this.fakeTex);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(this.fakeTex);
        textureState.setEnabled(true);
        quad.setRenderState((RenderState)textureState);
        this.monitorNode.updateGeometricState(0.0f, true);
        this.monitorNode.updateRenderState();
        this.monitorNode.setLightCombineMode(0);
        this.rootNode.attachChild((Spatial)this.monitorNode);
    }
}

