/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.ClodMesh;
import com.jme.scene.shape.Disk;
import com.jme.util.TextureKey;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.AseToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jmetest.renderer.loader.TestASEJmeWrite;

public class TestClodMesh
extends SimpleGame {
    private Node model;
    private ClodMesh cNode;
    private ClodMesh cNode2;
    private boolean useModel = true;
    private long lastPress = 0L;

    public static void main(String[] stringArray) {
        TestClodMesh testClodMesh = new TestClodMesh();
        testClodMesh.setDialogBehaviour(2);
        testClodMesh.start();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("load_here", false)) {
            try {
                this.rootNode = null;
                this.rootNode = (Node)BinaryImporter.getInstance().load(new File("rootNode.save"));
                this.rootNode.updateGeometricState(0.0f, true);
                this.rootNode.updateRenderState();
                this.cNode2 = (ClodMesh)this.rootNode.getChild(1);
                System.out.println("loaded here successfully");
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (System.currentTimeMillis() - this.lastPress > 100L) {
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("detail_down")) {
                if (this.useModel) {
                    this.cNode2.setTargetRecord(this.cNode2.getTargetRecord() + 10);
                } else {
                    this.cNode.setTargetRecord(this.cNode.getTargetRecord() + 25);
                }
                this.lastPress = System.currentTimeMillis();
            }
            if (KeyBindingManager.getKeyBindingManager().isValidCommand("detail_up")) {
                if (this.useModel) {
                    this.cNode2.setTargetRecord(this.cNode2.getTargetRecord() - 10);
                } else {
                    this.cNode.setTargetRecord(this.cNode.getTargetRecord() - 25);
                }
                this.lastPress = System.currentTimeMillis();
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("switch_models", false)) {
            this.useModel = !this.useModel;
            this.cNode.setCullMode(this.useModel ? 2 : 1);
            this.cNode2.setCullMode(!this.useModel ? 2 : 1);
        }
    }

    protected void simpleInitGame() {
        this.display.setTitle("Imposter Test");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 25.0f));
        this.cam.update();
        KeyBindingManager.getKeyBindingManager().set("load_here", 65);
        KeyBindingManager.getKeyBindingManager().set("detail_up", 78);
        KeyBindingManager.getKeyBindingManager().set("detail_down", 74);
        KeyBindingManager.getKeyBindingManager().set("switch_models", 50);
        InputStream inputStream = TestASEJmeWrite.class.getClassLoader().getResourceAsStream("jmetest/data/model/Statue.ase");
        URL uRL = TestASEJmeWrite.class.getClassLoader().getResource("jmetest/data/model/");
        if (inputStream == null) {
            System.out.println("Unable to find statue file, did you include jme-test.jar in classpath?");
            System.exit(0);
        }
        AseToJme aseToJme = new AseToJme();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            aseToJme.convert(inputStream, (OutputStream)byteArrayOutputStream);
            TextureKey.setOverridingLocation((URL)uRL);
            this.model = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.model.updateGeometricState(0.0f, true);
        this.cNode = new ClodMesh("model", (TriMesh)new Disk("disc", 50, 50, 8.0f), null);
        this.rootNode.attachChild((Spatial)this.cNode);
        this.cNode.setCullMode(2);
        this.cNode.setModelBound((BoundingVolume)new BoundingSphere());
        this.cNode.updateModelBound();
        Spatial spatial = this.model.getChild(0);
        while (spatial instanceof Node) {
            spatial = ((Node)spatial).getChild(0);
        }
        this.cNode2 = new ClodMesh("model", (TriMesh)spatial, null);
        this.rootNode.attachChild((Spatial)this.cNode2);
        this.cNode2.setCullMode(1);
        this.cNode2.setModelBound((BoundingVolume)new BoundingSphere());
        this.cNode2.updateModelBound();
    }
}

