/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Cone;
import com.jme.scene.shape.Cylinder;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;
import jmetest.renderer.TestBoxColor;

public class TestCylinder
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f).normalizeLocal();
    private Cylinder t;
    private Cone t2;

    public static void main(String[] stringArray) {
        TestCylinder testCylinder = new TestCylinder();
        testCylinder.setDialogBehaviour(2);
        testCylinder.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleNormalAxis(this.angle, this.axis);
        this.t.setLocalRotation(this.rotQuat);
        this.t2.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Cylinder Test");
        this.t = new Cylinder("Cylinder", 20, 50, 5.0f, 10.0f);
        this.t.setModelBound((BoundingVolume)new BoundingBox());
        this.t.updateModelBound();
        this.t.getLocalTranslation().set(-8.0f, 0.0f, 0.0f);
        this.rootNode.attachChild((Spatial)this.t);
        this.t2 = new Cone("Cone", 20, 50, 5.0f, 10.0f, true);
        this.t2.setModelBound((BoundingVolume)new BoundingBox());
        this.t2.updateModelBound();
        this.t2.getLocalTranslation().set(8.0f, 0.0f, 0.0f);
        this.rootNode.attachChild((Spatial)this.t2);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)2, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
        this.lightState.setTwoSidedLighting(true);
    }
}

