/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.DistanceSwitchModel;
import com.jme.scene.Spatial;
import com.jme.scene.SwitchModel;
import com.jme.scene.lod.DiscreteLodNode;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;
import jmetest.renderer.TestBoxColor;

public class TestDiscreteLOD
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private DiscreteLodNode dlod;

    public static void main(String[] stringArray) {
        TestDiscreteLOD testDiscreteLOD = new TestDiscreteLOD();
        testDiscreteLOD.setDialogBehaviour(2);
        testDiscreteLOD.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 10.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle * ((float)Math.PI / 180), this.axis);
        this.dlod.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Discrete Level of Detail Test");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 50.0f));
        this.cam.update();
        Sphere sphere = new Sphere("Sphere", 100, 100, 25.0f);
        sphere.setModelBound((BoundingVolume)new BoundingBox());
        sphere.updateModelBound();
        Sphere sphere2 = new Sphere("Sphere", 50, 50, 25.0f);
        sphere2.setModelBound((BoundingVolume)new BoundingBox());
        sphere2.updateModelBound();
        Sphere sphere3 = new Sphere("Sphere", 30, 20, 25.0f);
        sphere3.setModelBound((BoundingVolume)new BoundingBox());
        sphere3.updateModelBound();
        Sphere sphere4 = new Sphere("Sphere", 10, 10, 25.0f);
        sphere4.setModelBound((BoundingVolume)new BoundingBox());
        sphere4.updateModelBound();
        DistanceSwitchModel distanceSwitchModel = new DistanceSwitchModel(4);
        distanceSwitchModel.setModelDistance(0, 0.0f, 100.0f);
        distanceSwitchModel.setModelDistance(1, 100.0f, 200.0f);
        distanceSwitchModel.setModelDistance(2, 200.0f, 300.0f);
        distanceSwitchModel.setModelDistance(3, 300.0f, 1000.0f);
        this.dlod = new DiscreteLodNode("DLOD", (SwitchModel)distanceSwitchModel);
        this.dlod.attachChild((Spatial)sphere);
        this.dlod.attachChild((Spatial)sphere2);
        this.dlod.attachChild((Spatial)sphere3);
        this.dlod.attachChild((Spatial)sphere4);
        this.dlod.setActiveChild(0);
        this.rootNode.attachChild((Spatial)this.dlod);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
    }
}

