/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Disk;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;
import jmetest.renderer.TestBoxColor;

public class TestDisk
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private Disk t;

    public static void main(String[] stringArray) {
        TestDisk testDisk = new TestDisk();
        testDisk.setDialogBehaviour(2);
        testDisk.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 50.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle * ((float)Math.PI / 180), this.axis);
        this.t.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Disk Test");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 45.0f));
        this.cam.update();
        this.t = new Disk("Disk", 16, 32, 10.0f);
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.updateModelBound();
        this.rootNode.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
        this.lightState.setTwoSidedLighting(true);
    }
}

