/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.math.Vector3f;
import com.jme.scene.BillboardNode;
import com.jme.scene.ImposterNode;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.Md2ToJme;
import com.jmex.model.animation.KeyframeController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jmetest.renderer.loader.TestMd2JmeWrite;

public class TestImposterNode
extends SimpleGame {
    private Node fakeScene;
    private Node freakmd2;
    private String FILE_NAME = "jmetest/data/model/drfreak.md2";
    private String TEXTURE_NAME = "jmetest/data/model/drfreak.jpg";
    private ImposterNode iNode;

    public static void main(String[] stringArray) {
        TestImposterNode testImposterNode = new TestImposterNode();
        testImposterNode.setDialogBehaviour(2);
        testImposterNode.start();
    }

    protected void simpleInitGame() {
        long l;
        this.display.setTitle("Imposter Test");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 25.0f));
        this.cam.update();
        Md2ToJme md2ToJme = new Md2ToJme();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        URL uRL = TestMd2JmeWrite.class.getClassLoader().getResource(this.TEXTURE_NAME);
        URL uRL2 = TestMd2JmeWrite.class.getClassLoader().getResource(this.FILE_NAME);
        this.freakmd2 = null;
        try {
            l = System.currentTimeMillis();
            md2ToJme.convert(uRL2.openStream(), (OutputStream)byteArrayOutputStream);
            System.out.println("Time to convert from md2 to .jme:" + (System.currentTimeMillis() - l));
        }
        catch (IOException iOException) {
            System.out.println("damn exceptions:" + iOException.getMessage());
        }
        try {
            l = System.currentTimeMillis();
            this.freakmd2 = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            System.out.println("Time to convert from .jme to SceneGraph:" + (System.currentTimeMillis() - l));
        }
        catch (IOException iOException) {
            System.out.println("damn exceptions:" + iOException.getMessage());
        }
        ((KeyframeController)this.freakmd2.getChild(0).getController(0)).setSpeed(10.0f);
        ((KeyframeController)this.freakmd2.getChild(0).getController(0)).setRepeatType(1);
        this.fakeScene = new Node("Fake node");
        this.fakeScene.attachChild((Spatial)this.freakmd2);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)uRL, (int)2, (int)1));
        this.freakmd2.setRenderState((RenderState)textureState);
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        textureState2.setEnabled(true);
        textureState2.setTexture(TextureManager.loadTexture((URL)TestImposterNode.class.getClassLoader().getResource(this.TEXTURE_NAME), (int)2, (int)1));
        this.fakeScene.setRenderState((RenderState)textureState2);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.fakeScene.setRenderState((RenderState)zBufferState);
        this.fakeScene.updateRenderState();
        int n = 256;
        if (this.display.getHeight() > 512) {
            n = 512;
        }
        this.iNode = new ImposterNode("model imposter", 10.0f, n, n);
        this.iNode.attachChild((Spatial)this.fakeScene);
        this.iNode.setCameraDistance(100.0f);
        this.iNode.setRedrawRate(0.05f);
        BillboardNode billboardNode = new BillboardNode("imposter bbnode");
        billboardNode.setAlignment(0);
        billboardNode.attachChild((Spatial)this.iNode);
        this.rootNode.attachChild((Spatial)billboardNode);
    }

    protected void cleanup() {
        this.iNode.getTextureRenderer().cleanup();
        super.cleanup();
    }
}

