/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;
import jmetest.renderer.TestBoxColor;

public class TestMultitexture
extends SimpleGame {
    private TriMesh t;
    private Quaternion rotQuat;
    private float angle = 0.0f;
    private Vector3f axis;

    public static void main(String[] stringArray) {
        TestMultitexture testMultitexture = new TestMultitexture();
        testMultitexture.setDialogBehaviour(2);
        testMultitexture.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 25.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle * ((float)Math.PI / 180), this.axis);
        this.t.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.rotQuat = new Quaternion();
        this.axis = new Vector3f(1.0f, 1.0f, 0.5f);
        this.display.setTitle("Multitexturing");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 40.0f));
        this.cam.update();
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.t = new Box("Box", vector3f2, vector3f);
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.updateModelBound();
        this.t.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)2, (int)1);
        textureState.setTexture(texture2, 1);
        System.out.println("This video card has a total of " + TextureState.getNumberOfTotalUnits() + " texture units.");
        System.out.println("This video card has a total of " + TextureState.getNumberOfFixedUnits() + " fixed function pipeline texture units.");
        System.out.println("This video card has a total of " + TextureState.getNumberOfFragmentUnits() + " units available for fragment shaders.");
        System.out.println("This video card has a total of " + TextureState.getNumberOfVertexUnits() + " units available for vertex shaders.");
        this.t.copyTextureCoords(0, 0, 1);
        this.rootNode.setRenderState((RenderState)textureState);
    }
}

