/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Octahedron;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;
import jmetest.renderer.TestBoxColor;

public class TestOctahedron
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private Octahedron s;

    public static void main(String[] stringArray) {
        TestOctahedron testOctahedron = new TestOctahedron();
        testOctahedron.setDialogBehaviour(2);
        testOctahedron.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 25.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle * ((float)Math.PI / 180), this.axis);
        this.s.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Octahedron Test");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 100.0f));
        this.cam.update();
        this.s = new Octahedron("Octahedron", 20.0f);
        this.s.setModelBound((BoundingVolume)new BoundingBox());
        this.s.updateModelBound();
        this.rootNode.attachChild((Spatial)this.s);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
    }
}

