/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.NodeHandler;
import com.jme.input.action.InputActionInterface;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.net.URL;
import java.nio.FloatBuffer;
import jmetest.renderer.TestNodeSelectionAction;

public class TestScenegraph
extends SimpleGame {
    private Node scene;
    private NodeHandler nc1;
    private NodeHandler nc2;
    private NodeHandler nc3;
    private NodeHandler nc4;
    private NodeHandler nc5;
    private NodeHandler nc6;
    private Box box1;
    private Box box2;
    private Box box3;
    private Box box4;
    private Box box5;
    private Box box6;
    private Box selectionBox;
    private Node node1;
    private Node node2;
    private Node node3;
    private Node node4;
    private Node node5;
    private Node node6;
    private Text text;
    private Node selectedNode;
    private TextureState ts;
    private TextureState ts2;
    private TextureState ts3;
    private Line line;

    public static void main(String[] stringArray) {
        TestScenegraph testScenegraph = new TestScenegraph();
        testScenegraph.setDialogBehaviour(2);
        testScenegraph.start();
    }

    protected void simpleUpdate() {
        this.input.update(this.timer.getTimePerFrame());
        this.updateLines();
        this.selectionBox.setLocalTranslation(this.selectedNode.getWorldTranslation());
        this.selectionBox.setLocalRotation(this.selectedNode.getWorldRotation());
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("tex1", false)) {
            this.selectedNode.setRenderState((RenderState)this.ts);
            this.selectedNode.updateRenderState();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("tex2", false)) {
            this.selectedNode.setRenderState((RenderState)this.ts2);
            this.rootNode.updateRenderState();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("tex3", false)) {
            this.selectedNode.setRenderState((RenderState)this.ts3);
            this.rootNode.updateRenderState();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("notex", false)) {
            this.selectedNode.clearRenderState(6);
            this.rootNode.updateRenderState();
        }
    }

    private void updateLines() {
        this.scene.updateGeometricState(0.0f, true);
        FloatBuffer floatBuffer = this.line.getVertexBuffer(0);
        floatBuffer.rewind();
        BufferUtils.setInBuffer((Vector3f)this.node1.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)0);
        BufferUtils.setInBuffer((Vector3f)this.node2.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)1);
        BufferUtils.setInBuffer((Vector3f)this.node1.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)2);
        BufferUtils.setInBuffer((Vector3f)this.node3.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)3);
        BufferUtils.setInBuffer((Vector3f)this.node2.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)4);
        BufferUtils.setInBuffer((Vector3f)this.node4.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)5);
        BufferUtils.setInBuffer((Vector3f)this.node2.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)6);
        BufferUtils.setInBuffer((Vector3f)this.node5.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)7);
        BufferUtils.setInBuffer((Vector3f)this.node3.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)8);
        BufferUtils.setInBuffer((Vector3f)this.node6.getWorldTranslation(), (FloatBuffer)floatBuffer, (int)9);
    }

    protected void simpleInitGame() {
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(2);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -100.0f);
        Vector3f vector3f2 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, 1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.cam.update();
        this.display.setTitle("Test Scene Graph");
        this.lightState.setEnabled(false);
        KeyBindingManager.getKeyBindingManager().set("notex", 8);
        KeyBindingManager.getKeyBindingManager().set("tex1", 9);
        KeyBindingManager.getKeyBindingManager().set("tex2", 10);
        KeyBindingManager.getKeyBindingManager().set("tex3", 11);
        KeyBindingManager.getKeyBindingManager().set("tog_bounds", 48);
        Vector3f vector3f5 = new Vector3f(-5.0f, -5.0f, -5.0f);
        Vector3f vector3f6 = new Vector3f(5.0f, 5.0f, 5.0f);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(0.0f, 0.0f, 150.0f));
        directionalLight.setEnabled(true);
        this.lightState.detachAll();
        this.lightState.attach((Light)directionalLight);
        this.text = Text.createDefaultTextLabel((String)"Selected Node", (String)"Selected Node: Node 1");
        this.text.setLocalTranslation(new Vector3f(0.0f, 20.0f, 0.0f));
        this.fpsNode.attachChild((Spatial)this.text);
        this.scene = new Node("3D Scene Node");
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        this.selectionBox = new Box("Selection", vector3f5.mult(1.25f), vector3f6.mult(1.25f));
        this.selectionBox.setDefaultColor(new ColorRGBA(0.0f, 0.6f, 0.0f, 0.3f));
        this.selectionBox.setRenderState((RenderState)alphaState);
        this.selectionBox.setModelBound((BoundingVolume)new BoundingSphere());
        this.selectionBox.updateModelBound();
        this.selectionBox.setLightCombineMode(0);
        this.selectionBox.setRenderQueueMode(3);
        this.node1 = new Node("Node 1");
        this.box1 = new Box("Box 1", vector3f5, vector3f6);
        this.node1.attachChild((Spatial)this.box1);
        this.node1.setLocalTranslation(new Vector3f(0.0f, 30.0f, 0.0f));
        this.selectedNode = this.node1;
        this.box1.setModelBound((BoundingVolume)new BoundingSphere());
        this.box1.updateModelBound();
        this.node2 = new Node("Node 2");
        this.box2 = new Box("Box 2", vector3f5, vector3f6);
        this.node2.attachChild((Spatial)this.box2);
        this.node1.attachChild((Spatial)this.node2);
        this.node2.setLocalTranslation(new Vector3f(-20.0f, -20.0f, 0.0f));
        this.box2.setModelBound((BoundingVolume)new BoundingSphere());
        this.box2.updateModelBound();
        this.node3 = new Node("Node 3");
        this.box3 = new Box("Box 3", vector3f5, vector3f6);
        this.node3.attachChild((Spatial)this.box3);
        this.node1.attachChild((Spatial)this.node3);
        this.node3.setLocalTranslation(new Vector3f(20.0f, -20.0f, 0.0f));
        this.box3.setModelBound((BoundingVolume)new BoundingSphere());
        this.box3.updateModelBound();
        this.node4 = new Node("Node 4");
        this.box4 = new Box("Box 4", vector3f5, vector3f6);
        this.node4.attachChild((Spatial)this.box4);
        this.node2.attachChild((Spatial)this.node4);
        this.node4.setLocalTranslation(new Vector3f(-20.0f, -20.0f, 0.0f));
        this.box4.setModelBound((BoundingVolume)new BoundingSphere());
        this.box4.updateModelBound();
        this.node5 = new Node("Node 5");
        this.box5 = new Box("Box 5", vector3f5, vector3f6);
        this.node5.attachChild((Spatial)this.box5);
        this.node2.attachChild((Spatial)this.node5);
        this.node5.setLocalTranslation(new Vector3f(20.0f, -20.0f, 0.0f));
        this.box5.setModelBound((BoundingVolume)new BoundingSphere());
        this.box5.updateModelBound();
        this.node6 = new Node("Node 6");
        this.box6 = new Box("Box 6", vector3f5, vector3f6);
        this.node6.attachChild((Spatial)this.box6);
        this.node3.attachChild((Spatial)this.node6);
        this.node6.setLocalTranslation(new Vector3f(0.0f, -20.0f, 0.0f));
        this.box6.setModelBound((BoundingVolume)new BoundingSphere());
        this.box6.updateModelBound();
        FloatBuffer floatBuffer = BufferUtils.createVector3Buffer((int)10);
        this.line = new Line("Connection", floatBuffer, null, null, null);
        this.line.setLightCombineMode(0);
        this.line.setLineWidth(2.5f);
        this.line.setStipplePattern((short)-21846);
        this.line.setStippleFactor(5);
        this.ts = this.display.getRenderer().createTextureState();
        this.ts.setEnabled(true);
        Texture texture = TextureManager.loadTexture((URL)TestScenegraph.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1);
        this.ts.setTexture(texture);
        this.ts2 = this.display.getRenderer().createTextureState();
        this.ts2.setEnabled(true);
        Texture texture2 = TextureManager.loadTexture((URL)TestScenegraph.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)2, (int)1);
        this.ts2.setTexture(texture2);
        this.ts3 = this.display.getRenderer().createTextureState();
        this.ts3.setEnabled(true);
        Texture texture3 = TextureManager.loadTexture((URL)TestScenegraph.class.getClassLoader().getResource("jmetest/data/texture/snowflake.png"), (int)2, (int)1);
        this.ts3.setTexture(texture3);
        this.node1.setRenderState((RenderState)this.ts);
        this.scene.attachChild((Spatial)this.node1);
        this.rootNode.attachChild((Spatial)this.line);
        this.rootNode.attachChild((Spatial)this.scene);
        this.scene.attachChild((Spatial)this.selectionBox);
        this.nc1 = new NodeHandler((Spatial)this.node1, 5.0f, 1.0f);
        this.nc2 = new NodeHandler((Spatial)this.node2, 5.0f, 1.0f);
        this.nc3 = new NodeHandler((Spatial)this.node3, 5.0f, 1.0f);
        this.nc4 = new NodeHandler((Spatial)this.node4, 5.0f, 1.0f);
        this.nc5 = new NodeHandler((Spatial)this.node5, 5.0f, 1.0f);
        this.nc6 = new NodeHandler((Spatial)this.node6, 5.0f, 1.0f);
        this.input = new InputHandler();
        this.input.addToAttachedHandlers((InputHandler)this.nc1);
        this.input.addToAttachedHandlers((InputHandler)this.nc2);
        this.input.addToAttachedHandlers((InputHandler)this.nc3);
        this.input.addToAttachedHandlers((InputHandler)this.nc4);
        this.input.addToAttachedHandlers((InputHandler)this.nc5);
        this.input.addToAttachedHandlers((InputHandler)this.nc6);
        this.input.setEnabledOfAttachedHandlers(false);
        this.nc1.setEnabled(true);
        KeyBindingManager keyBindingManager = KeyBindingManager.getKeyBindingManager();
        keyBindingManager.set("node1", 2);
        keyBindingManager.set("node2", 3);
        keyBindingManager.set("node3", 4);
        keyBindingManager.set("node4", 5);
        keyBindingManager.set("node5", 6);
        keyBindingManager.set("node6", 7);
        this.input.addAction((InputActionInterface)new TestNodeSelectionAction(this, 1), "node1", false);
        this.input.addAction((InputActionInterface)new TestNodeSelectionAction(this, 2), "node2", false);
        this.input.addAction((InputActionInterface)new TestNodeSelectionAction(this, 3), "node3", false);
        this.input.addAction((InputActionInterface)new TestNodeSelectionAction(this, 4), "node4", false);
        this.input.addAction((InputActionInterface)new TestNodeSelectionAction(this, 5), "node5", false);
        this.input.addAction((InputActionInterface)new TestNodeSelectionAction(this, 6), "node6", false);
    }

    public void setSelectedNode(int n) {
        this.input.setEnabledOfAttachedHandlers(false);
        switch (n) {
            case 1: {
                this.nc1.setEnabled(true);
                this.selectedNode = this.node1;
                break;
            }
            case 2: {
                this.nc2.setEnabled(true);
                this.selectedNode = this.node2;
                break;
            }
            case 3: {
                this.nc3.setEnabled(true);
                this.selectedNode = this.node3;
                break;
            }
            case 4: {
                this.nc4.setEnabled(true);
                this.selectedNode = this.node4;
                break;
            }
            case 5: {
                this.nc5.setEnabled(true);
                this.selectedNode = this.node5;
                break;
            }
            case 6: {
                this.nc6.setEnabled(true);
                this.selectedNode = this.node6;
            }
        }
        this.text.print("Selected Node: " + this.selectedNode.getName());
    }
}

