/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.curve.BezierCurve;
import com.jme.curve.Curve;
import com.jme.curve.CurveController;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Skybox;
import com.jme.scene.Spatial;
import com.jme.scene.VBOInfo;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Sphere;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.XMLparser.Converters.Md2ToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.JOptionPane;
import jmetest.curve.TestBezierCurve;
import jmetest.renderer.TestSkybox;
import jmetest.renderer.state.TestTextureState;

public class TestSerial
extends SimpleGame {
    ByteArrayOutputStream skybox;
    ByteArrayOutputStream freaky;
    ByteArrayOutputStream curve;
    Node mainNode = new Node("blarg");

    public static void main(String[] stringArray) {
        TestSerial testSerial = new TestSerial();
        JOptionPane.showMessageDialog(null, "This will take a while to load.\nPress U to load Dr.Freak, Press O to load skybox, Press I to load curve");
        testSerial.setDialogBehaviour(1);
        testSerial.start();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("load_freak", false)) {
            try {
                this.rootNode.detachChild((Spatial)this.mainNode);
                this.mainNode = (Node)new ObjectInputStream(new ByteArrayInputStream(this.freaky.toByteArray())).readObject();
                this.rootNode.attachChild((Spatial)this.mainNode);
                this.rootNode.updateRenderState();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                System.exit(0);
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("load_sky", false)) {
            try {
                this.rootNode.detachChild((Spatial)this.mainNode);
                this.mainNode = (Node)new ObjectInputStream(new ByteArrayInputStream(this.skybox.toByteArray())).readObject();
                this.rootNode.attachChild((Spatial)this.mainNode);
                this.rootNode.updateRenderState();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                System.exit(0);
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("load_curve", false)) {
            try {
                this.rootNode.detachChild((Spatial)this.mainNode);
                this.mainNode = (Node)new ObjectInputStream(new ByteArrayInputStream(this.curve.toByteArray())).readObject();
                this.rootNode.attachChild((Spatial)this.mainNode);
                this.rootNode.updateRenderState();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(0);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                System.exit(0);
            }
        }
    }

    protected void simpleInitGame() {
        System.out.println("Requesting skybox");
        this.skybox = this.getSkyBox();
        try {
            System.out.println("requesting drfreak");
            this.freaky = this.getFreaky();
            System.out.println("Requesting curve");
            this.curve = this.getCurve();
        }
        catch (IOException iOException) {
            throw new JmeException("damn");
        }
        KeyBindingManager.getKeyBindingManager().set("load_sky", 24);
        KeyBindingManager.getKeyBindingManager().set("load_freak", 22);
        KeyBindingManager.getKeyBindingManager().set("load_curve", 23);
        this.rootNode.attachChild((Spatial)this.mainNode);
    }

    private ByteArrayOutputStream getSkyBox() {
        Node node = new Node("sky");
        Torus torus = new Torus("Torus", 20, 20, 5.0f, 10.0f);
        torus.setModelBound((BoundingVolume)new BoundingBox());
        torus.updateModelBound();
        torus.setLocalTranslation(new Vector3f(-40.0f, 0.0f, 10.0f));
        torus.setVBOInfo(new VBOInfo(true));
        node.attachChild((Spatial)torus);
        Sphere sphere = new Sphere("Sphere", 20, 20, 25.0f);
        sphere.setModelBound((BoundingVolume)new BoundingBox());
        sphere.updateModelBound();
        sphere.setLocalTranslation(new Vector3f(40.0f, 0.0f, -10.0f));
        node.attachChild((Spatial)sphere);
        sphere.setVBOInfo(new VBOInfo(true));
        Box box = new Box("box", new Vector3f(-25.0f, 70.0f, -45.0f), 20.0f, 20.0f, 20.0f);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        box.setVBOInfo(new VBOInfo(true));
        node.attachChild((Spatial)box);
        Skybox skybox = new Skybox("skybox", 570.0f, 570.0f, 570.0f);
        Texture texture = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/north.jpg"), (int)2, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/south.jpg"), (int)2, (int)1);
        Texture texture3 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/east.jpg"), (int)2, (int)1);
        Texture texture4 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/west.jpg"), (int)2, (int)1);
        Texture texture5 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/top.jpg"), (int)2, (int)1);
        Texture texture6 = TextureManager.loadTexture((URL)TestSkybox.class.getClassLoader().getResource("jmetest/data/texture/bottom.jpg"), (int)2, (int)1);
        skybox.setTexture(0, texture);
        skybox.setTexture(3, texture4);
        skybox.setTexture(1, texture2);
        skybox.setTexture(2, texture3);
        skybox.setTexture(4, texture5);
        skybox.setTexture(5, texture6);
        node.attachChild((Spatial)skybox);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(node);
            return byteArrayOutputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private ByteArrayOutputStream getFreaky() throws IOException {
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestTextureState.class.getClassLoader().getResource("jmetest/data/model/drfreak.jpg"), (int)2, (int)1));
        Md2ToJme md2ToJme = new Md2ToJme();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        md2ToJme.convert(TestSerial.class.getClassLoader().getResource("jmetest/data/model/drfreak.md2").openStream(), (OutputStream)byteArrayOutputStream);
        Node node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        node.getChild(0).getController(0).setSpeed(10.0f);
        node.setRenderState((RenderState)textureState);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream2);
            objectOutputStream.writeObject(node);
            return byteArrayOutputStream2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private ByteArrayOutputStream getCurve() {
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(-4.0f, 0.0f, 0.0f), new Vector3f(-2.0f, 3.0f, 2.0f), new Vector3f(2.0f, -3.0f, -2.0f), new Vector3f(4.0f, 0.0f, 0.0f)};
        BezierCurve bezierCurve = new BezierCurve("Curve", vector3fArray);
        ColorRGBA[] colorRGBAArray = new ColorRGBA[]{new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f), new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f), new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f), new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f)};
        bezierCurve.setColorBuffer(0, BufferUtils.createFloatBuffer((ColorRGBA[])colorRGBAArray));
        Vector3f vector3f2 = new Vector3f(-0.1f, -0.1f, -0.1f);
        Vector3f vector3f3 = new Vector3f(0.1f, 0.1f, 0.1f);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        Box box = new Box("Control 1", vector3f2, vector3f3);
        box.setModelBound((BoundingVolume)new BoundingSphere());
        box.updateModelBound();
        box.setLocalTranslation(vector3fArray[0]);
        Box box2 = new Box("Control 2", vector3f2, vector3f3);
        box2.setModelBound((BoundingVolume)new BoundingSphere());
        box2.updateModelBound();
        box2.setLocalTranslation(vector3fArray[1]);
        Box box3 = new Box("Control 3", vector3f2, vector3f3);
        box3.setModelBound((BoundingVolume)new BoundingSphere());
        box3.updateModelBound();
        box3.setLocalTranslation(vector3fArray[2]);
        Box box4 = new Box("Control 4", vector3f2, vector3f3);
        box4.setModelBound((BoundingVolume)new BoundingSphere());
        box4.updateModelBound();
        box4.setLocalTranslation(vector3fArray[3]);
        Box box5 = new Box("Controlled Box", vector3f2.mult(5.0f), vector3f3.mult(5.0f));
        box5.setModelBound((BoundingVolume)new BoundingSphere());
        box5.updateModelBound();
        box5.setLocalTranslation(vector3fArray[0]);
        CurveController curveController = new CurveController((Curve)bezierCurve, (Spatial)box5);
        box5.addController((Controller)curveController);
        curveController.setRepeatType(2);
        curveController.setUpVector(vector3f);
        curveController.setSpeed(0.5f);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBezierCurve.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        box5.setRenderState((RenderState)textureState);
        Node node = new Node("blargggg");
        node.setRenderState((RenderState)zBufferState);
        node.attachChild((Spatial)box);
        node.attachChild((Spatial)box2);
        node.attachChild((Spatial)box3);
        node.attachChild((Spatial)box4);
        node.attachChild((Spatial)box5);
        node.attachChild((Spatial)bezierCurve);
        node.setLocalScale(10.0f);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(node);
            return byteArrayOutputStream;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

