/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.VBOInfo;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.logging.Level;

public class TestSharedMesh
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private Sphere s;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestSharedMesh testSharedMesh = new TestSharedMesh();
        testSharedMesh.setDialogBehaviour(2);
        testSharedMesh.start();
    }

    protected void simpleUpdate() {
        if (this.tpf < 1.0f) {
            this.angle += this.tpf * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.s.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        SharedMesh sharedMesh;
        int n;
        this.display.setTitle("jME - Sphere");
        this.s = new Sphere("Sphere", 20, 20, 25.0f);
        this.s.setModelBound((BoundingVolume)new BoundingBox());
        this.s.updateModelBound();
        this.s.setVBOInfo(new VBOInfo(true));
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestSharedMesh.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        textureState2.setEnabled(true);
        textureState2.setTexture(TextureManager.loadTexture((URL)TestSharedMesh.class.getClassLoader().getResource("jmetest/data/texture/grass.jpg"), (int)6, (int)1));
        TextureState textureState3 = this.display.getRenderer().createTextureState();
        textureState3.setEnabled(true);
        textureState3.setTexture(TextureManager.loadTexture((URL)TestSharedMesh.class.getClassLoader().getResource("jmetest/data/texture/clouds.png"), (int)6, (int)1));
        TextureState textureState4 = this.display.getRenderer().createTextureState();
        textureState4.setEnabled(true);
        textureState4.setTexture(TextureManager.loadTexture((URL)TestSharedMesh.class.getClassLoader().getResource("jmetest/data/texture/water.png"), (int)6, (int)1));
        Node node = new Node("n1");
        Node node2 = new Node("n2");
        Node node3 = new Node("n3");
        Node node4 = new Node("n4");
        node.setLocalTranslation(new Vector3f(750.0f, 0.0f, 0.0f));
        node2.setLocalTranslation(new Vector3f(750.0f, 0.0f, 750.0f));
        node3.setLocalTranslation(new Vector3f(-750.0f, 0.0f, 750.0f));
        node4.setLocalTranslation(new Vector3f(-750.0f, 0.0f, -750.0f));
        this.rootNode.attachChild((Spatial)node);
        this.rootNode.attachChild((Spatial)node2);
        this.rootNode.attachChild((Spatial)node3);
        this.rootNode.attachChild((Spatial)node4);
        WireframeState wireframeState = this.display.getRenderer().createWireframeState();
        wireframeState.setEnabled(true);
        for (n = 0; n < 100; ++n) {
            sharedMesh = new SharedMesh("Share" + n, (TriMesh)this.s);
            sharedMesh.setLocalTranslation(new Vector3f((float)Math.random() * 500.0f - 250.0f, (float)Math.random() * 500.0f - 250.0f, (float)Math.random() * 500.0f - 250.0f));
            sharedMesh.setRenderState((RenderState)textureState);
            sharedMesh.setRenderState((RenderState)wireframeState);
            node.attachChild((Spatial)sharedMesh);
        }
        for (n = 0; n < 100; ++n) {
            sharedMesh = new SharedMesh("Share" + n, (TriMesh)this.s);
            sharedMesh.setLocalTranslation(new Vector3f((float)Math.random() * 500.0f - 250.0f, (float)Math.random() * 500.0f - 250.0f, (float)Math.random() * 500.0f - 250.0f));
            sharedMesh.setRenderState((RenderState)textureState2);
            sharedMesh.setLightCombineMode(0);
            node2.attachChild((Spatial)sharedMesh);
        }
        for (n = 0; n < 100; ++n) {
            sharedMesh = new SharedMesh("Share" + n, (TriMesh)this.s);
            sharedMesh.setLocalTranslation(new Vector3f((float)Math.random() * 500.0f - 250.0f, (float)Math.random() * 500.0f - 250.0f, (float)Math.random() * 500.0f - 250.0f));
            sharedMesh.setRenderState((RenderState)textureState3);
            node3.attachChild((Spatial)sharedMesh);
        }
        for (n = 0; n < 100; ++n) {
            sharedMesh = new SharedMesh("Share" + n, (TriMesh)this.s);
            sharedMesh.setLocalTranslation(new Vector3f((float)Math.random() * 1000.0f - 500.0f, (float)Math.random() * 1000.0f - 500.0f, (float)Math.random() * 1000.0f - 500.0f));
            sharedMesh.setRenderState((RenderState)textureState4);
            node4.attachChild((Spatial)sharedMesh);
        }
    }
}

