/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Matrix3f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.SharedNode;
import com.jme.scene.Spatial;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureKey;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.MilkToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import jmetest.renderer.loader.TestMilkJmeWrite;

public class TestSharedNode
extends SimpleGame {
    Node file = null;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestSharedNode testSharedNode = new TestSharedNode();
        testSharedNode.setDialogBehaviour(2);
        testSharedNode.start();
    }

    protected void simpleUpdate() {
        this.file.updateGeometricState(this.tpf, true);
    }

    protected void simpleInitGame() {
        SharedNode sharedNode;
        URL uRL;
        this.display.setTitle("jME - Sphere");
        this.display.getRenderer().setBackgroundColor(ColorRGBA.white);
        this.display.setMinSamples(4);
        URL uRL2 = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/run.ms3d");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (uRL2 == null) {
            System.out.println("Unable to find milkshape file, did you include jme-test.jar in classpath?");
            System.exit(0);
        }
        MilkToJme milkToJme = new MilkToJme();
        try {
            milkToJme.convert(uRL2.openStream(), (OutputStream)byteArrayOutputStream);
            uRL = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/");
            TextureKey.setOverridingLocation((URL)uRL);
            this.file = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            this.file.setModelBound((BoundingVolume)new BoundingBox());
            this.file.updateModelBound();
        }
        catch (IOException iOException) {
            System.out.println("Damn exceptions:" + iOException);
        }
        uRL = new Node("n1");
        for (int i = 0; i < 100; ++i) {
            sharedNode = new SharedNode("Share" + i, this.file);
            sharedNode.setLocalTranslation(new Vector3f((float)Math.random() * 200.0f - 100.0f, (float)Math.random() * 200.0f - 100.0f, (float)Math.random() * 200.0f - 100.0f));
            uRL.attachChild((Spatial)sharedNode);
        }
        uRL.setLocalTranslation(new Vector3f(500.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)uRL);
        SharedNode sharedNode2 = new SharedNode("Share1", (Node)uRL);
        sharedNode2.setLocalTranslation(new Vector3f(200.0f, 100.0f, 200.0f));
        sharedNode2.setLocalScale(new Vector3f(0.5f, 0.5f, 0.5f));
        sharedNode = new Matrix3f();
        sharedNode.fromAngleAxis(2.0f, new Vector3f(1.0f, 1.0f, 0.0f));
        sharedNode2.setLocalRotation((Matrix3f)sharedNode);
        this.rootNode.attachChild((Spatial)sharedNode2);
        SharedNode sharedNode3 = new SharedNode("Share1", (Node)uRL);
        sharedNode3.setLocalTranslation(new Vector3f(-200.0f, 100.0f, 200.0f));
        this.rootNode.attachChild((Spatial)sharedNode3);
        SharedNode sharedNode4 = new SharedNode("Share1", (Node)uRL);
        sharedNode4.setLocalTranslation(new Vector3f(200.0f, 100.0f, -200.0f));
        this.rootNode.attachChild((Spatial)sharedNode4);
        SharedNode sharedNode5 = new SharedNode("Share1", (Node)uRL);
        sharedNode5.setLocalTranslation(new Vector3f(-200.0f, -100.0f, -200.0f));
        this.rootNode.attachChild((Spatial)sharedNode5);
    }
}

