/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.logging.Level;

public class TestSphere
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private Sphere s;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestSphere testSphere = new TestSphere();
        testSphere.setDialogBehaviour(2);
        testSphere.start();
    }

    protected void simpleUpdate() {
        if (this.tpf < 1.0f) {
            this.angle += this.tpf * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.s.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME - Sphere");
        this.s = new Sphere("Sphere", 63, 50, 25.0f);
        this.s.setLocalTranslation(new Vector3f(0.0f, 0.0f, -40.0f));
        this.s.setModelBound((BoundingVolume)new BoundingBox());
        this.s.updateModelBound();
        this.rootNode.attachChild((Spatial)this.s);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestSphere.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
    }
}

