/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.BaseGame;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestText
extends BaseGame {
    private Text text;
    private Camera cam;
    private Node scene;

    public static void main(String[] stringArray) {
        TestText testText = new TestText();
        testText.setDialogBehaviour(2);
        testText.start();
    }

    protected void update(float f) {
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.display.setTitle("Test Text");
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA(0.0f, 0.0f, 255.0f, 1.0f);
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f4 = new Vector3f(-1.0f, 0.0f, 0.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
    }

    protected void initGame() {
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestText.class.getClassLoader().getResource("jmetest/data/font/font.png"), (int)2, (int)1));
        textureState.setEnabled(true);
        this.text = new Text("text", "Testing Text! Look, symbols: <>?!^&*_");
        this.text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        this.text.setRenderState((RenderState)textureState);
        this.text.setRenderState((RenderState)alphaState);
        this.scene = new Node("3D Scene Node");
        this.scene.attachChild((Spatial)this.text);
        this.cam.update();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

