/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.InputHandler;
import com.jme.input.NodeHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.SpotLight;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.CameraNode;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import java.net.URL;
import java.util.logging.Level;
import jmetest.renderer.TestBoxColor;

public class TestTorus
extends BaseGame {
    private Camera cam;
    private CameraNode camNode;
    private Node root;
    private InputHandler input;
    private Timer timer;
    private Text fps;
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private float tpf;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private Torus t;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestTorus testTorus = new TestTorus();
        testTorus.setDialogBehaviour(2);
        testTorus.start();
    }

    protected void update(float f) {
        this.timer.update();
        this.tpf = this.timer.getTimePerFrame();
        this.input.update(this.tpf);
        if (this.tpf < 1.0f) {
            this.angle += this.tpf * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.t.setLocalRotation(this.rotQuat);
        this.root.updateGeometricState(this.tpf, true);
        this.fps.print("FPS: " + (int)this.timer.getFrameRate() + " : " + this.display.getRenderer().getStatistics());
        this.display.getRenderer().clearStatistics();
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.root);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        this.display.getRenderer().setCamera(this.cam);
        this.camNode = new CameraNode("Camera Node", this.cam);
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -100.0f));
        this.camNode.updateWorldData(0.0f);
        this.input = new NodeHandler((Spatial)this.camNode, 10.0f, 1.0f);
        this.display.setTitle("Torus Test");
        this.display.getRenderer().enableStatistics(true);
        this.timer = Timer.getTimer();
    }

    protected void initGame() {
        Node node = new Node("scene");
        this.root = new Node("Root node");
        this.t = new Torus("Torus", 50, 50, 5.0f, 10.0f);
        this.t.setModelBound((BoundingVolume)new BoundingBox());
        this.t.updateModelBound();
        node.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1));
        node.setRenderState((RenderState)textureState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        SpotLight spotLight = new SpotLight();
        spotLight.setDiffuse(new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f));
        spotLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        spotLight.setDirection(new Vector3f(-250.0f, -100.0f, 0.0f));
        spotLight.setLocation(new Vector3f(250.0f, 100.0f, 0.0f));
        spotLight.setAngle(1.0f);
        SpotLight spotLight2 = new SpotLight();
        spotLight2.setDiffuse(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        spotLight2.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        spotLight2.setDirection(new Vector3f(250.0f, -10.0f, 0.0f));
        spotLight2.setLocation(new Vector3f(-250.0f, 10.0f, 0.0f));
        spotLight2.setAngle(1.0f);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(0.25f, 0.75f, 0.25f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.25f, 0.25f, 0.25f, 1.0f));
        directionalLight.setDirection(new Vector3f(150.0f, 0.0f, 150.0f));
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.attach((Light)spotLight);
        lightState.attach((Light)directionalLight);
        lightState.attach((Light)spotLight2);
        spotLight.setEnabled(true);
        spotLight2.setEnabled(true);
        directionalLight.setEnabled(true);
        node.setRenderState((RenderState)lightState);
        node.setRenderState((RenderState)zBufferState);
        this.root.attachChild((Spatial)node);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        textureState2.setTexture(TextureManager.loadTexture((URL)TestTorus.class.getClassLoader().getResource("jmetest/data/font/font.png"), (int)2, (int)1));
        textureState2.setEnabled(true);
        this.fps = new Text("FPS counter", "");
        this.fps.setRenderState((RenderState)textureState2);
        this.fps.setRenderState((RenderState)alphaState);
        this.root.attachChild((Spatial)this.fps);
        this.root.setCullMode(3);
        this.root.updateGeometricState(0.0f, true);
        this.root.updateRenderState();
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

