/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer.loader;

import com.jme.animation.AnimationController;
import com.jme.animation.Bone;
import com.jme.animation.BoneAnimation;
import com.jme.animation.SkinNode;
import com.jme.app.SimpleGame;
import com.jme.input.FirstPersonHandler;
import com.jme.input.KeyBindingManager;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.util.BoneDebugger;
import com.jmex.model.collada.ColladaImporter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class TestColladaLoading
extends SimpleGame {
    AnimationController ac;
    boolean boneOn = false;

    public static void main(String[] stringArray) {
        TestColladaLoading testColladaLoading = new TestColladaLoading();
        testColladaLoading.setDialogBehaviour(2);
        testColladaLoading.start();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("bones", false)) {
            this.boneOn = !this.boneOn;
        }
    }

    protected void simpleRender() {
        if (this.boneOn) {
            BoneDebugger.drawBones((Spatial)this.rootNode, (Renderer)this.display.getRenderer(), (boolean)true);
        }
    }

    protected void simpleInitGame() {
        BoneAnimation boneAnimation;
        KeyBindingManager.getKeyBindingManager().set("bones", 57);
        this.cam.setAxes(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        this.cam.setLocation(new Vector3f(0.0f, -100.0f, 20.0f));
        this.input = new FirstPersonHandler(this.cam, 80.0f, 1.0f);
        URL uRL = TestColladaLoading.class.getClassLoader().getResource("jmetest/data/model/collada/");
        InputStream inputStream = TestColladaLoading.class.getClassLoader().getResourceAsStream("jmetest/data/model/collada/man.dae");
        InputStream inputStream2 = TestColladaLoading.class.getClassLoader().getResourceAsStream("jmetest/data/model/collada/man_walk.dae");
        if (inputStream == null) {
            System.out.println("Unable to find file, did you include jme-test.jar in classpath?");
            System.exit(0);
        }
        ColladaImporter.load((InputStream)inputStream, (URL)uRL, (String)"model");
        SkinNode skinNode = ColladaImporter.getSkinNode((String)((String)ColladaImporter.getSkinNodeNames().get(0)));
        Bone bone = ColladaImporter.getSkeleton((String)((String)ColladaImporter.getSkeletonNames().get(0)));
        ColladaImporter.cleanUp();
        ColladaImporter.load((InputStream)inputStream2, (URL)uRL, (String)"anim");
        ArrayList arrayList = ColladaImporter.getControllerNames();
        if (arrayList != null) {
            System.out.println("Number of animations: " + arrayList.size());
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println((String)arrayList.get(i));
            }
            boneAnimation = ColladaImporter.getAnimationController((String)((String)arrayList.get(0)));
            this.ac = new AnimationController();
            this.ac.addAnimation(boneAnimation);
            this.ac.setRepeatType(1);
            this.ac.setActive(true);
            this.ac.setActiveAnimation(boneAnimation);
            bone.addController((Controller)this.ac);
        }
        this.rootNode.attachChild((Spatial)skinNode);
        this.rootNode.attachChild((Spatial)bone);
        this.rootNode.updateGeometricState(0.0f, true);
        ColladaImporter.cleanUp();
        this.lightState.detachAll();
        boneAnimation = new PointLight();
        boneAnimation.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        boneAnimation.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        boneAnimation.setLocation(new Vector3f(10.0f, -50.0f, 20.0f));
        boneAnimation.setEnabled(true);
        this.lightState.attach((Light)boneAnimation);
    }
}

