/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer.loader;

import com.jme.app.SimpleGame;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.Md2ToJme;
import com.jmex.model.animation.KeyframeController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.JOptionPane;

public class TestMd2JmeWrite
extends SimpleGame {
    float totalFPS;
    long totalCounts;
    private KeyframeController kc;
    private static final String helpMessage = "Fun with KeyframeController and md2 models.  Keys are:\nR: Make drFreak run\nH: Make drFreak attack\nZ: Toggle repeat type wrap and cycle\nE: Do a quick transform to the begining\nB: Do a smooth transform to the begining\nQ: Do a smooth transform to drfreak's death\n";

    public static void main(String[] stringArray) {
        JOptionPane.showMessageDialog(null, helpMessage);
        TestMd2JmeWrite testMd2JmeWrite = new TestMd2JmeWrite();
        testMd2JmeWrite.setDialogBehaviour(1);
        testMd2JmeWrite.start();
    }

    protected void simpleInitGame() {
        long l;
        Md2ToJme md2ToJme = new Md2ToJme();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        URL uRL = TestMd2JmeWrite.class.getClassLoader().getResource("jmetest/data/model/drfreak.jpg");
        URL uRL2 = TestMd2JmeWrite.class.getClassLoader().getResource("jmetest/data/model/drfreak.md2");
        Node node = null;
        try {
            l = System.currentTimeMillis();
            md2ToJme.convert(uRL2.openStream(), (OutputStream)byteArrayOutputStream);
            System.out.println("Time to convert from md2 to .jme:" + (System.currentTimeMillis() - l));
        }
        catch (IOException iOException) {
            System.out.println("damn exceptions:" + iOException.getMessage());
        }
        try {
            l = System.currentTimeMillis();
            node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            System.out.println("Time to convert from .jme to SceneGraph:" + (System.currentTimeMillis() - l));
        }
        catch (IOException iOException) {
            System.out.println("damn exceptions:" + iOException.getMessage());
        }
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)uRL, (int)6, (int)1));
        node.setRenderState((RenderState)textureState);
        node.setLocalTranslation(new Vector3f(0.0f, 0.0f, -20.0f));
        node.setLocalScale(0.5f);
        this.kc = (KeyframeController)node.getChild(0).getController(0);
        this.kc.setSpeed(10.0f);
        KeyBindingManager.getKeyBindingManager().set("start_run", 19);
        KeyBindingManager.getKeyBindingManager().set("start_hit", 35);
        KeyBindingManager.getKeyBindingManager().set("toggle_wrap", 44);
        KeyBindingManager.getKeyBindingManager().set("start_end", 18);
        KeyBindingManager.getKeyBindingManager().set("start_smoothbegin", 48);
        KeyBindingManager.getKeyBindingManager().set("start_smoothdeath", 16);
        this.rootNode.attachChild((Spatial)node);
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("start_run", false)) {
            this.kc.setNewAnimationTimes(39.0f, 44.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("start_hit", false)) {
            this.kc.setNewAnimationTimes(45.0f, 52.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("start_end", false)) {
            this.kc.setNewAnimationTimes(0.0f, 196.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("start_smoothbegin", false)) {
            this.kc.setSmoothTranslation(0.0f, 25.0f, 0.0f, 196.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("start_smoothdeath", false)) {
            this.kc.setSmoothTranslation(175.0f, 25.0f, 175.0f, 182.0f);
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_wrap", false)) {
            if (this.kc.getRepeatType() == 2) {
                this.kc.setRepeatType(1);
            } else {
                this.kc.setRepeatType(2);
            }
        }
    }
}

