/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer.loader;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.scene.Spatial;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.Md3ToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class TestMd3JmeWrite
extends SimpleGame {
    public static void main(String[] stringArray) {
        TestMd3JmeWrite testMd3JmeWrite = new TestMd3JmeWrite();
        testMd3JmeWrite.setDialogBehaviour(2);
        testMd3JmeWrite.start();
    }

    protected void simpleInitGame() {
        Md3ToJme md3ToJme = new Md3ToJme();
        URL uRL = null;
        uRL = TestMd3JmeWrite.class.getClassLoader().getResource("jmetest/data/model/lara/lara_lower.md3");
        URL uRL2 = TestMd3JmeWrite.class.getClassLoader().getResource("jmetest/data/model/lara/default.bmp");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            md3ToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
            System.out.println("Done converting, now watch how fast it loads!");
            long l = System.currentTimeMillis();
            Spatial spatial = (Spatial)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            spatial.setModelBound((BoundingVolume)new BoundingBox());
            spatial.updateModelBound();
            System.out.println("Finished loading time is " + (System.currentTimeMillis() - l));
            TextureState textureState = this.display.getRenderer().createTextureState();
            textureState.setTexture(TextureManager.loadTexture((URL)uRL2, (int)2, (int)1));
            textureState.setEnabled(true);
            spatial.setRenderState((RenderState)textureState);
            this.rootNode.attachChild(spatial);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

