/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer.state;

import com.jme.app.SimpleGame;
import com.jme.input.NodeHandler;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.VertexProgramState;
import com.jme.scene.state.WireframeState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestVertexProgramState
extends SimpleGame {
    private final float[] lightPosition = new float[]{-0.8f, 0.8f, 0.8f, 0.0f};

    public static void main(String[] stringArray) {
        TestVertexProgramState testVertexProgramState = new TestVertexProgramState();
        testVertexProgramState.setDialogBehaviour(2);
        testVertexProgramState.start();
    }

    protected void simpleInitGame() {
        this.display.setTitle("Vertex Programs");
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.02f, 0.0f, 0.776f, 1.0f));
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 45.0f));
        this.cam.update();
        this.input = new NodeHandler((Spatial)this.rootNode, 10.0f, 2.0f);
        Torus torus = this.createShadedTorus();
        Torus torus2 = this.createOutlineTorus();
        this.rootNode.attachChild((Spatial)torus);
        this.rootNode.attachChild((Spatial)torus2);
        this.rootNode.updateRenderState();
    }

    private Torus createShadedTorus() {
        VertexProgramState vertexProgramState = this.display.getRenderer().createVertexProgramState();
        vertexProgramState.setParameter(this.lightPosition, 8);
        vertexProgramState.load(TestVertexProgramState.class.getClassLoader().getResource("jmetest/data/images/celshaderARB.vp"));
        vertexProgramState.setEnabled(true);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestVertexProgramState.class.getClassLoader().getResource("jmetest/data/images/shader.png"), (int)1, (int)0));
        Torus torus = new Torus("shadedTorus", 128, 32, 3.0f, 5.0f);
        torus.setRenderState((RenderState)vertexProgramState);
        torus.setRenderState((RenderState)textureState);
        return torus;
    }

    private Torus createOutlineTorus() {
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(1);
        cullState.setEnabled(true);
        WireframeState wireframeState = this.display.getRenderer().createWireframeState();
        wireframeState.setLineWidth(6.0f);
        wireframeState.setFace(1);
        wireframeState.setEnabled(true);
        Torus torus = new Torus("outlineTorus", 128, 32, 3.0f, 5.0f);
        torus.setDefaultColor(ColorRGBA.black);
        torus.setRenderState((RenderState)cullState);
        torus.setRenderState((RenderState)wireframeState);
        return torus;
    }
}

