/*
 * Decompiled with CFR 0.152.
 */
package jmetest.sound;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.KeyBindingManager;
import com.jme.input.KeyboardLookHandler;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.KeyInputAction;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleMesh;
import com.jmex.sound.openAL.SoundSystem;
import java.net.URL;

public class PongRevisited
extends SimpleGame {
    private Box player;
    private Box computer;
    private Sphere ball;
    private Box lowerWall;
    private Box upperWall;
    private ParticleMesh manager;
    private ParticleMesh bmanager;
    private int snode;
    private int ballSound;
    private int explodeSound;
    private static final int WALL_BOUNCE_EVENT = 2;
    private static final int MISS_EVENT = 3;
    private float ballXSpeed = -1.0f;
    private float ballYSpeed = 0.0f;
    private int difficulty = 10;
    private Text playerScoreText;
    private Text computerScoreText;
    private int computerScore;
    private int playerScore;
    private Node uiNode;

    protected void simpleInitGame() {
        SoundSystem.init((Camera)this.display.getRenderer().getCamera(), (int)0);
        this.snode = SoundSystem.createSoundNode();
        this.uiNode = new Node("UINODE");
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        this.playerScoreText = Text.createDefaultTextLabel((String)"playerScore", (String)"Player : 0");
        this.computerScoreText = Text.createDefaultTextLabel((String)"compScore", (String)"Computer : 0");
        this.computerScoreText.setLocalTranslation(new Vector3f(200.0f, 0.0f, 0.0f));
        this.uiNode.attachChild((Spatial)this.playerScoreText);
        this.uiNode.attachChild((Spatial)this.computerScoreText);
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.cam.setFrustum(1.0f, 5000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, -850.0f);
        Vector3f vector3f2 = new Vector3f(1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, 1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
        this.player = new Box("Player", new Vector3f(0.0f, 0.0f, 0.0f), 5.0f, 50.0f, 5.0f);
        this.player.getLocalTranslation().x = -400.0f;
        this.player.setModelBound((BoundingVolume)new BoundingBox());
        this.player.updateModelBound();
        this.computer = new Box("Computer", new Vector3f(0.0f, 0.0f, 0.0f), 5.0f, 50.0f, 5.0f);
        this.computer.getLocalTranslation().x = 400.0f;
        this.computer.setModelBound((BoundingVolume)new BoundingBox());
        this.computer.updateModelBound();
        this.ball = new Sphere("Ball", 15, 15, 5.0f);
        this.ball.setModelBound((BoundingVolume)new BoundingBox());
        this.ball.getLocalTranslation().z = -0.0f;
        this.ball.updateModelBound();
        this.ballSound = SoundSystem.create3DSample((URL)PongRevisited.class.getClassLoader().getResource("jmetest/data/sound/turn.ogg"));
        this.explodeSound = SoundSystem.create3DSample((URL)PongRevisited.class.getClassLoader().getResource("jmetest/data/sound/explosion.ogg"));
        SoundSystem.bindEventToSample((int)this.ballSound, (int)2);
        SoundSystem.bindEventToSample((int)this.explodeSound, (int)3);
        SoundSystem.setSampleMaxAudibleDistance((int)this.ballSound, (int)5000);
        SoundSystem.addSampleToNode((int)this.ballSound, (int)this.snode);
        SoundSystem.addSampleToNode((int)this.explodeSound, (int)this.snode);
        this.lowerWall = new Box("Left Wall", new Vector3f(0.0f, -300.0f, 0.0f), 450.0f, 5.0f, 5.0f);
        this.lowerWall.setModelBound((BoundingVolume)new BoundingBox());
        this.lowerWall.updateModelBound();
        this.upperWall = new Box("Right Wall", new Vector3f(0.0f, 300.0f, 0.0f), 450.0f, 5.0f, 5.0f);
        this.upperWall.setModelBound((BoundingVolume)new BoundingBox());
        this.upperWall.updateModelBound();
        this.manager = ParticleFactory.buildParticles((String)"particles", (int)300);
        this.manager.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        this.manager.setMaximumAngle((float)Math.PI);
        this.manager.getParticleController().setSpeed(1.4f);
        this.manager.setMinimumLifeTime(1000.0f);
        this.manager.setMaximumLifeTime(1500.0f);
        this.manager.setStartSize(5.0f);
        this.manager.setEndSize(5.0f);
        this.manager.setStartColor(new ColorRGBA(1.0f, 0.312f, 0.121f, 1.0f));
        this.manager.setEndColor(new ColorRGBA(1.0f, 0.24313726f, 0.03137255f, 0.0f));
        this.manager.getParticleController().setControlFlow(false);
        this.manager.setReleaseRate(300);
        this.manager.setReleaseVariance(0.0f);
        this.manager.setInitialVelocity(1.0f);
        this.manager.setParticleSpinSpeed(0.0f);
        this.manager.warmUp(1000);
        this.bmanager = ParticleFactory.buildParticles((String)"particles", (int)100);
        this.bmanager.setEmissionDirection(new Vector3f(-1.0f, 0.0f, 0.0f));
        this.bmanager.setMaximumAngle(0.1f);
        this.bmanager.getParticleController().setSpeed(0.4f);
        this.bmanager.setMinimumLifeTime(100.0f);
        this.bmanager.setMaximumLifeTime(150.0f);
        this.bmanager.setStartSize(5.0f);
        this.bmanager.setEndSize(5.0f);
        this.bmanager.setStartColor(new ColorRGBA(1.0f, 0.312f, 0.121f, 1.0f));
        this.bmanager.setEndColor(new ColorRGBA(1.0f, 0.24313726f, 0.03137255f, 0.0f));
        this.bmanager.getParticleController().setControlFlow(false);
        this.bmanager.setReleaseRate(300);
        this.bmanager.setReleaseVariance(0.0f);
        this.bmanager.setInitialVelocity(0.3f);
        this.bmanager.setParticleSpinSpeed(-0.5f);
        this.bmanager.warmUp(1000);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)PongRevisited.class.getClassLoader().getResource("jmetest/data/texture/flaresmall.jpg"), (int)6, (int)1));
        textureState.setEnabled(true);
        this.manager.getParticleController().setRepeatType(0);
        Node node = new Node("Particle Nodes");
        node.setRenderState((RenderState)alphaState);
        node.setRenderState((RenderState)textureState);
        Node node2 = new Node("Particle Nodes");
        node2.setRenderState((RenderState)alphaState);
        node2.setRenderState((RenderState)textureState);
        node2.attachChild((Spatial)this.bmanager);
        node.attachChild((Spatial)this.manager);
        this.rootNode.attachChild((Spatial)node);
        this.rootNode.attachChild((Spatial)node2);
        this.rootNode.attachChild((Spatial)this.player);
        this.lightState.setEnabled(!this.lightState.isEnabled());
        this.rootNode.attachChild((Spatial)this.computer);
        this.rootNode.attachChild((Spatial)this.lowerWall);
        this.rootNode.attachChild((Spatial)this.upperWall);
        this.rootNode.attachChild((Spatial)this.ball);
        this.rootNode.attachChild((Spatial)this.uiNode);
        this.input = new KeyboardLookHandler(this.cam, 40.0f, 0.0f);
        this.input.addAction((InputActionInterface)new MoveUpAction(), "moveUp", 200, true);
        this.input.addAction((InputActionInterface)new MoveDownAction(), "moveDown", 208, true);
        KeyBindingManager.getKeyBindingManager().remove("lookUp");
        KeyBindingManager.getKeyBindingManager().remove("lookDown");
    }

    public void simpleUpdate() {
        this.manager.getParticleController().setRepeatType(0);
        if (this.checkPlayer()) {
            SoundSystem.setSamplePosition((int)this.ballSound, (float)(this.cam.getLocation().x + 5.0f), (float)this.cam.getLocation().y, (float)this.cam.getLocation().z);
            SoundSystem.onEvent((int)2);
        }
        if (this.checkComputer()) {
            SoundSystem.setSamplePosition((int)this.ballSound, (float)(this.cam.getLocation().x - 5.0f), (float)this.cam.getLocation().y, (float)this.cam.getLocation().z);
            SoundSystem.onEvent((int)2);
        }
        if (this.checkWalls()) {
            SoundSystem.setSamplePosition((int)this.ballSound, (float)(this.cam.getLocation().x + 5.0f), (float)this.cam.getLocation().y, (float)this.cam.getLocation().z);
            SoundSystem.onEvent((int)2);
        }
        this.moveBall();
        this.moveComputer();
        if (this.ball.getLocalTranslation().x < this.player.getWorldTranslation().x) {
            SoundSystem.setSamplePosition((int)this.explodeSound, (float)(this.cam.getLocation().x + 5.0f), (float)this.cam.getLocation().y, (float)this.cam.getLocation().z);
            SoundSystem.onEvent((int)3);
            this.computerScoreText.print("Computer : " + ++this.computerScore);
            this.manager.getParticleController().setRepeatType(1);
            this.manager.forceRespawn();
            this.manager.setLocalTranslation(new Vector3f(this.ball.getLocalTranslation().x, this.ball.getLocalTranslation().y, this.ball.getLocalTranslation().z));
            this.reset();
        }
        if (this.ball.getLocalTranslation().x > this.computer.getWorldTranslation().x) {
            SoundSystem.setSamplePosition((int)this.explodeSound, (float)(this.cam.getLocation().x - 5.0f), (float)this.cam.getLocation().y, (float)this.cam.getLocation().z);
            SoundSystem.onEvent((int)3);
            this.playerScoreText.print("Player : " + ++this.playerScore);
            this.manager.getParticleController().setRepeatType(1);
            this.manager.forceRespawn();
            this.manager.setLocalTranslation(new Vector3f(this.ball.getLocalTranslation().x, this.ball.getLocalTranslation().y, this.ball.getLocalTranslation().z));
            if (this.difficulty > 2) {
                --this.difficulty;
            }
            this.reset();
        }
        this.fps.print("");
        SoundSystem.update((float)this.tpf);
        super.simpleUpdate();
    }

    private void moveBall() {
        this.ball.getLocalTranslation().x += this.ballXSpeed;
        this.ball.getLocalTranslation().y += this.ballYSpeed;
        this.bmanager.getLocalTranslation().x = this.ball.getLocalTranslation().x;
        this.bmanager.getLocalTranslation().y = this.ball.getLocalTranslation().y;
        if (this.ballXSpeed < 0.0f) {
            this.bmanager.setEmissionDirection(new Vector3f(1.0f, this.ballYSpeed, 0.0f));
        } else {
            this.bmanager.setEmissionDirection(new Vector3f(-1.0f, -this.ballYSpeed, 0.0f));
        }
    }

    private void moveComputer() {
        float f = Math.abs(this.ball.getLocalTranslation().y - this.computer.getLocalTranslation().y);
        if (this.ballXSpeed > 0.0f) {
            this.computer.getLocalTranslation().y = this.computer.getLocalTranslation().y < this.ball.getLocalTranslation().y ? (float)((double)this.computer.getLocalTranslation().y + Math.rint(f / (float)this.difficulty)) : (float)((double)this.computer.getLocalTranslation().y - Math.rint(f / (float)this.difficulty));
        } else if (this.computer.getLocalTranslation().y < 0.0f) {
            this.computer.getLocalTranslation().y += 2.0f;
        } else if (this.computer.getLocalTranslation().y > 0.0f) {
            this.computer.getLocalTranslation().y -= 2.0f;
        }
    }

    private boolean checkPlayer() {
        if (this.ball.getWorldBound().intersects(this.player.getWorldBound())) {
            this.ballXSpeed = 0.0f - this.ballXSpeed;
            float f = this.ball.getLocalTranslation().y - this.player.getLocalTranslation().y;
            this.ballYSpeed += f / 4.0f;
            return true;
        }
        return false;
    }

    public boolean checkComputer() {
        if (this.ball.getWorldBound().intersects(this.computer.getWorldBound())) {
            this.ballXSpeed = 0.0f - this.ballXSpeed;
            SoundSystem.setSamplePosition((int)this.ballSound, (float)(this.cam.getLocation().x - 5.0f), (float)this.cam.getLocation().y, (float)this.cam.getLocation().z);
            float f = this.ball.getLocalTranslation().y - this.computer.getLocalTranslation().y;
            this.ballYSpeed += f / 4.0f;
            return true;
        }
        return false;
    }

    public boolean checkWalls() {
        if (this.ball.getWorldBound().intersects(this.lowerWall.getWorldBound())) {
            this.ballYSpeed = 0.0f - this.ballYSpeed;
            return true;
        }
        if (this.ball.getWorldBound().intersects(this.upperWall.getWorldBound())) {
            this.ballYSpeed = 0.0f - this.ballYSpeed;
            return true;
        }
        return false;
    }

    public void simpleRender() {
        SoundSystem.draw((int)this.snode);
        super.simpleRender();
    }

    public static void main(String[] stringArray) {
        PongRevisited pongRevisited = new PongRevisited();
        pongRevisited.setDialogBehaviour(2);
        pongRevisited.start();
    }

    private void reset() {
        this.player.getLocalTranslation().x = -400.0f;
        this.player.getLocalTranslation().y = 0.0f;
        this.player.getLocalTranslation().z = 0.0f;
        this.computer.getLocalTranslation().x = 400.0f;
        this.computer.getLocalTranslation().y = 0.0f;
        this.computer.getLocalTranslation().z = 0.0f;
        this.ball.getLocalTranslation().x = 0.0f;
        this.ball.getLocalTranslation().y = 0.0f;
        this.ball.getLocalTranslation().z = 0.0f;
        this.ballXSpeed = 1.0f;
        this.ballYSpeed = 0.0f;
    }

    class MoveDownAction
    extends KeyInputAction {
        int numBullets;

        MoveDownAction() {
        }

        public void performAction(InputActionEvent inputActionEvent) {
            ((PongRevisited)PongRevisited.this).player.getLocalTranslation().y -= 5.0f;
        }
    }

    class MoveUpAction
    extends KeyInputAction {
        int numBullets;

        MoveUpAction() {
        }

        public void performAction(InputActionEvent inputActionEvent) {
            ((PongRevisited)PongRevisited.this).player.getLocalTranslation().y += 5.0f;
        }
    }
}

