/*
 * Decompiled with CFR 0.152.
 */
package jmetest.sound.fsound;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.sound.fmod.SoundSystem;
import com.jmex.sound.fmod.scene.Configuration;
import java.net.URL;

public class TestSoundGraph
extends SimpleGame {
    private int snode;
    int boxCenter;
    int boxRight;
    int boxLeft;
    int background;
    float volume;
    Box box;
    Box box2;
    Box box3;

    public static void main(String[] stringArray) {
        TestSoundGraph testSoundGraph = new TestSoundGraph();
        testSoundGraph.setDialogBehaviour(2);
        testSoundGraph.start();
    }

    protected void simpleUpdate() {
        this.volume = (float)((double)this.volume + 0.009);
        SoundSystem.setStreamVolume((int)this.background, (int)((int)this.volume));
        SoundSystem.update((float)0.0f);
    }

    protected void simpleRender() {
        SoundSystem.draw((int)this.snode);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Test Sound Graph");
        SoundSystem.init((Camera)this.cam, (int)0);
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.box = new Box("Box", vector3f2, vector3f);
        this.box.setModelBound((BoundingVolume)new BoundingSphere());
        this.box.updateModelBound();
        this.box.setLocalTranslation(new Vector3f(0.0f, 0.0f, -50.0f));
        this.box2 = new Box("Box2", (Vector3f)vector3f2.clone(), (Vector3f)vector3f.clone());
        this.box2.setModelBound((BoundingVolume)new BoundingSphere());
        this.box2.updateModelBound();
        this.box2.setLocalTranslation(new Vector3f(100.0f, 10.0f, -50.0f));
        this.box3 = new Box("Box3", (Vector3f)vector3f2.clone(), (Vector3f)vector3f.clone());
        this.box3.setModelBound((BoundingVolume)new BoundingSphere());
        this.box3.updateModelBound();
        this.box3.setLocalTranslation(new Vector3f(-100.0f, 10.0f, -50.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestSoundGraph.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.box);
        this.rootNode.attachChild((Spatial)this.box2);
        this.rootNode.attachChild((Spatial)this.box3);
        this.snode = SoundSystem.createSoundNode();
        this.boxCenter = SoundSystem.create3DSample((String)"jmetest/data/sound/CHAR_CRE_1.ogg");
        this.boxRight = SoundSystem.cloneSample((int)this.boxCenter);
        this.boxLeft = SoundSystem.cloneSample((int)this.boxCenter);
        this.background = SoundSystem.createStream((String)"jmetest/data/sound/test.ogg", (boolean)false);
        SoundSystem.playStream((int)this.background);
        SoundSystem.setStreamVolume((int)this.background, (int)0);
        SoundSystem.setSampleMaxAudibleDistance((int)this.boxLeft, (int)100);
        SoundSystem.setSamplePosition((int)this.boxLeft, (float)this.box3.getLocalTranslation().x, (float)this.box3.getLocalTranslation().y, (float)this.box3.getLocalTranslation().z);
        SoundSystem.setSampleMinAudibleDistance((int)this.boxLeft, (int)4);
        SoundSystem.addSampleToNode((int)this.boxLeft, (int)this.snode);
        SoundSystem.setSampleMaxAudibleDistance((int)this.boxRight, (int)100);
        SoundSystem.setSamplePosition((int)this.boxRight, (float)this.box2.getLocalTranslation().x, (float)this.box2.getLocalTranslation().y, (float)this.box2.getLocalTranslation().z);
        SoundSystem.setSampleMinAudibleDistance((int)this.boxRight, (int)4);
        SoundSystem.addSampleToNode((int)this.boxRight, (int)this.snode);
        Configuration configuration = new Configuration();
        configuration.setDistortion(-1.0f, 60.0f, 6000.0f, 1000.0f, 3000.0f);
    }
}

