/*
 * Decompiled with CFR 0.152.
 */
package jmetest.sound.openal;

import com.jme.util.LoggingSystem;
import com.jmex.sound.openAL.SoundSystem;
import com.jmex.sound.openAL.objects.util.dsp.Equalizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import jmetest.sound.openal.NextButtonHandler;
import jmetest.sound.openal.SliderChangeListener;

public class TestStreamPlayer {
    public static void main(String[] stringArray) throws Exception {
        SoundSystem.init(null, (int)0);
        final JFrame jFrame = new JFrame();
        final JButton jButton = new JButton("Select directory");
        jFrame.getContentPane().add(jButton);
        jFrame.setDefaultCloseOperation(3);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final JFileChooser jFileChooser = new JFileChooser("C:/SAVE/Apps/ogg");
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.showOpenDialog(null);
                ((JButton)actionEvent.getSource()).setEnabled(false);
                try {
                    new Thread(new Runnable(){

                        public void run() {
                            try {
                                TestStreamPlayer.startPlayer(jFrame, jButton, jFileChooser.getSelectedFile());
                            }
                            catch (Exception exception) {
                                System.exit(-1);
                            }
                        }
                    }).start();
                }
                catch (Exception exception) {
                    System.exit(-1);
                }
            }
        });
        jFrame.setSize(300, 100);
        jFrame.setVisible(true);
    }

    protected static void startPlayer(JFrame jFrame, JButton jButton, File file) throws Exception {
        int n;
        int n2;
        Equalizer equalizer = new Equalizer(new int[]{50, 200, 800, 3200, 12800}, -12.0, 12.0);
        SoundSystem.setEqualizer((Equalizer)equalizer);
        jFrame.getContentPane().remove(jButton);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JButton jButton2 = new JButton(">>");
        JButton jButton3 = new JButton("<<");
        JSlider jSlider = new JSlider(-12, 12, 0);
        jSlider.setOrientation(1);
        jSlider.setPaintTicks(true);
        jSlider.setMajorTickSpacing(1);
        JSlider jSlider2 = new JSlider(-12, 12, 0);
        jSlider2.setOrientation(1);
        jSlider2.setPaintTicks(true);
        jSlider2.setMajorTickSpacing(1);
        JSlider jSlider3 = new JSlider(-12, 12, 0);
        jSlider3.setOrientation(1);
        jSlider3.setPaintTicks(true);
        jSlider3.setMajorTickSpacing(1);
        JSlider jSlider4 = new JSlider(-12, 12, 0);
        jSlider4.setOrientation(1);
        jSlider4.setPaintTicks(true);
        jSlider4.setMajorTickSpacing(1);
        JSlider jSlider5 = new JSlider(-12, 12, 0);
        jSlider5.setOrientation(1);
        jSlider5.setPaintTicks(true);
        jSlider5.setMajorTickSpacing(1);
        GridLayout gridLayout = new GridLayout(1, 5);
        jPanel2.setLayout(gridLayout);
        jPanel2.add(jSlider);
        jPanel2.add(jSlider2);
        jPanel2.add(jSlider3);
        jPanel2.add(jSlider4);
        jPanel2.add(jSlider5);
        NextButtonHandler nextButtonHandler = new NextButtonHandler();
        NextButtonHandler nextButtonHandler2 = new NextButtonHandler();
        jButton2.addActionListener(nextButtonHandler);
        jButton3.addActionListener(nextButtonHandler2);
        jPanel.add((Component)jButton2, "East");
        jPanel.add((Component)jButton3, "West");
        jPanel.add((Component)jButton, "North");
        jPanel.add((Component)jPanel2, "South");
        jFrame.getContentPane().add(jPanel);
        String[] stringArray = null;
        if (file != null && file.isDirectory()) {
            stringArray = file.list();
        } else {
            System.exit(-1);
        }
        ArrayList<Integer> arrayList = null;
        ArrayList<String> arrayList2 = null;
        if (stringArray != null && stringArray.length > 0) {
            arrayList = new ArrayList<Integer>();
            arrayList2 = new ArrayList<String>();
        } else {
            LoggingSystem.getLogger().log(Level.INFO, "The path entered does not contain any file");
            LoggingSystem.getLogger().log(Level.INFO, file.getAbsolutePath());
            System.exit(-1);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            n = SoundSystem.createStream((String)(file.getAbsolutePath() + File.separator + stringArray[n2]), (boolean)false);
            if (!SoundSystem.isStreamOpened((int)n)) continue;
            arrayList.add(n);
            arrayList2.add(stringArray[n2]);
            jSlider.addChangeListener(new SliderChangeListener(equalizer, n, 50));
            jSlider2.addChangeListener(new SliderChangeListener(equalizer, n, 200));
            jSlider3.addChangeListener(new SliderChangeListener(equalizer, n, 800));
            jSlider4.addChangeListener(new SliderChangeListener(equalizer, n, 3200));
            jSlider5.addChangeListener(new SliderChangeListener(equalizer, n, 12800));
        }
        n2 = arrayList.size();
        if (n2 > 0) {
            System.out.print("Found " + n2 + " playable songs in this directory");
            for (n = 0; n < n2; ++n) {
                int n3 = (Integer)arrayList.get(n);
                SoundSystem.playStream((int)n3);
                for (int i = (int)SoundSystem.getStreamLength((int)n3); i > 0; i -= 1000) {
                    jButton.setText("Playing " + (String)arrayList2.get(n) + " " + i / 1000 / 60 + " m " + i / 1000 % 60 + "s");
                    jFrame.repaint();
                    jButton.repaint();
                    jFrame.pack();
                    Thread.sleep(1000L);
                    if (nextButtonHandler.isPressed()) {
                        i = 0;
                        nextButtonHandler.setPressed(false);
                        SoundSystem.stopStream((int)n3);
                    }
                    if (!nextButtonHandler2.isPressed()) continue;
                    nextButtonHandler2.setPressed(false);
                    SoundSystem.stopStream((int)n3);
                    n = n == 0 ? -1 : (n -= 2);
                    i = 0;
                }
            }
        }
    }
}

