/*
 * Decompiled with CFR 0.152.
 */
package jmetest.stress.swarm;

import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CollisionTreeManager {
    private Node parent;
    private final float[] levelMults;
    private ArrayList<Spatial> organizationLeafs = new ArrayList();
    private Map<SectorIndex, Sector> sectorMap = new HashMap<SectorIndex, Sector>();
    private ArrayList<Sector> unusedSectors = new ArrayList();
    private SectorIndex tmp_index = new SectorIndex();

    public CollisionTreeManager(Node node, float[] fArray) {
        this.parent = node;
        if (fArray.length == 0) {
            throw new IllegalArgumentException("Number of levels must be greater than zero.");
        }
        this.levelMults = new float[fArray.length];
        float f = 0.0f;
        for (int i = 0; i < fArray.length; ++i) {
            float f2 = fArray[i];
            if (!(f2 > f)) {
                throw new IllegalArgumentException("levelDistances must be ascending in size");
            }
            f = f2;
            this.levelMults[i] = 1.0f / f2;
        }
    }

    public void add(Spatial spatial) {
        if (spatial.getParent() != null) {
            throw new IllegalArgumentException("added spatial must not be attached to a node!");
        }
        this.parent.attachChild(spatial);
        this.organizationLeafs.add(spatial);
    }

    public void remove(Spatial spatial) {
        int n = this.organizationLeafs.indexOf(spatial);
        this.remove(n);
    }

    private void remove(int n) {
        Spatial spatial;
        if (n != -1 && (spatial = this.organizationLeafs.remove(n)).getParent() != null) {
            spatial.getParent().detachChild(spatial);
        }
    }

    public void disable() {
        for (int i = this.organizationLeafs.size() - 1; i >= 0; --i) {
            Spatial spatial = this.organizationLeafs.get(i);
            this.parent.attachChild(spatial);
        }
        this.removeSectors((Spatial)this.parent);
    }

    private void removeSectors(Spatial spatial) {
        if (spatial instanceof Node) {
            Node node = (Node)spatial;
            for (int i = node.getQuantity() - 1; i >= 0; --i) {
                Spatial spatial2 = node.getChild(i);
                this.removeSectors(spatial2);
            }
            if (node instanceof Sector) {
                this.removeIfEmpty((Sector)node);
            }
        }
    }

    public void reorganize() {
        for (int i = this.organizationLeafs.size() - 1; i >= 0; --i) {
            Sector sector;
            Spatial spatial = this.organizationLeafs.get(i);
            SectorIndex sectorIndex = this.getIndex(spatial, 0);
            if (spatial.getParent() == null) {
                this.remove(i);
                continue;
            }
            if (spatial.getParent() instanceof Sector) {
                sector = (Sector)spatial.getParent();
                if (!sector.getIndex().equals(sectorIndex)) {
                    sector.detachChild(spatial);
                    this.removeIfEmpty(sector);
                    sector = null;
                }
            } else {
                sector = null;
            }
            if (sector != null) continue;
            sector = this.getSector(sectorIndex);
            sector.attachChild(spatial);
        }
    }

    private void removeIfEmpty(Sector sector) {
        if (sector.getQuantity() == 0) {
            sector.getParent().detachChild((Spatial)sector);
            this.sectorMap.remove(sector.index);
            this.unusedSectors.add(sector);
        }
    }

    private Sector getSector(SectorIndex sectorIndex) {
        Sector sector = this.sectorMap.get(sectorIndex);
        if (sector == null) {
            int n = this.unusedSectors.size();
            if (n > 0) {
                sector = this.unusedSectors.remove(n - 1);
                sector.index.set(sectorIndex);
            } else {
                sector = new Sector("", sectorIndex);
            }
            this.sectorMap.put(sector.getIndex(), sector);
            int n2 = sectorIndex.getLevel();
            if (n2 < this.levelMults.length - 1) {
                sectorIndex = this.getIndex(sectorIndex, n2 + 1);
                this.getSector(sectorIndex).attachChild((Spatial)sector);
            } else {
                this.parent.attachChild((Spatial)sector);
            }
        }
        return sector;
    }

    private SectorIndex getIndex(SectorIndex sectorIndex, int n) {
        float f = this.levelMults[sectorIndex.getLevel()];
        float f2 = (float)sectorIndex.x / f;
        float f3 = (float)sectorIndex.y / f;
        float f4 = (float)sectorIndex.z / f;
        return this.getIndexFromPos(f2, f3, f4, n);
    }

    private SectorIndex getIndex(Spatial spatial, int n) {
        Vector3f vector3f = spatial.getWorldTranslation();
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        return this.getIndexFromPos(f, f2, f3, n);
    }

    private SectorIndex getIndexFromPos(float f, float f2, float f3, int n) {
        float f4 = this.levelMults[n];
        this.tmp_index.set((int)(f * f4), (int)(f2 * f4), (int)(f3 * f4), n);
        return this.tmp_index;
    }

    public class Sector
    extends Node {
        private static final long serialVersionUID = 1L;
        private SectorIndex index;

        public Sector(String string, SectorIndex sectorIndex) {
            super(string);
            this.index = new SectorIndex();
            this.index.set(sectorIndex);
        }

        public SectorIndex getIndex() {
            return this.index;
        }
    }

    protected class SectorIndex {
        private int x;
        private int y;
        private int z;
        private int level;
        private int hash;

        private SectorIndex() {
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof SectorIndex) {
                SectorIndex sectorIndex = (SectorIndex)object;
                return this.x == sectorIndex.x && this.y == sectorIndex.y && this.z == sectorIndex.z && this.level == sectorIndex.level;
            }
            return false;
        }

        protected void set(SectorIndex sectorIndex) {
            this.x = sectorIndex.x;
            this.y = sectorIndex.y;
            this.z = sectorIndex.z;
            this.level = sectorIndex.level;
            this.hash = this.doHash();
        }

        protected void set(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.level = n4;
            this.hash = this.doHash();
        }

        private int doHash() {
            return this.x ^ ((this.level << 10 ^ this.z) << 10 ^ this.y) << 10;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

