/*
 * Decompiled with CFR 0.152.
 */
package jmetest.terrain;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Vector3f;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Pyramid;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.MidPointHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import jmetest.terrain.TestTerrain;

public class TestTerrainTrees
extends SimpleGame {
    public static void main(String[] stringArray) {
        TestTerrainTrees testTerrainTrees = new TestTerrainTrees();
        testTerrainTrees.setDialogBehaviour(2);
        testTerrainTrees.start();
    }

    protected void simpleInitGame() {
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(2);
        this.display.setTitle("Terrain Test");
        this.cam.setLocation(new Vector3f(320.0f, 250.0f, 320.0f));
        this.cam.setFrustumFar(2000.0f);
        this.cam.update();
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setEnabled(false);
        this.rootNode.setRenderState((RenderState)fogState);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.lightState.setTwoSidedLighting(true);
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(128, 1.9f);
        Vector3f vector3f = new Vector3f(5.0f, 1.0f, 5.0f);
        TerrainBlock terrainBlock = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        terrainBlock.setDetailTexture(1, 4);
        terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock.updateModelBound();
        terrainBlock.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)terrainBlock);
        this.rootNode.setRenderState((RenderState)cullState);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)midPointHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(512);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        textureState2.setEnabled(true);
        Texture texture3 = TextureManager.loadTexture((URL)TestTerrainTrees.class.getClassLoader().getResource("jmetest/data/texture/grass.jpg"), (int)6, (int)1);
        textureState2.setTexture(texture3);
        Pyramid pyramid = new Pyramid("Pyramid", 10.0f, 20.0f);
        pyramid.setModelBound((BoundingVolume)new BoundingBox());
        pyramid.updateModelBound();
        pyramid.setRenderState((RenderState)textureState2);
        pyramid.setTextureCombineMode(5);
        for (int i = 0; i < 500; ++i) {
            SharedMesh sharedMesh = new SharedMesh("tree" + i, (TriMesh)pyramid);
            float f = (float)Math.random() * 128.0f * 5.0f;
            float f2 = (float)Math.random() * 128.0f * 5.0f;
            sharedMesh.setLocalTranslation(new Vector3f(f, terrainBlock.getHeight(f, f2) + 10.0f, f2));
            this.rootNode.attachChild((Spatial)sharedMesh);
        }
        this.rootNode.lock();
    }
}

