/*
 * Decompiled with CFR 0.152.
 */
package jmetest.util;

import com.jme.animation.SpatialTransformer;
import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.light.Light;
import com.jme.light.LightControllerManager;
import com.jme.light.PointLight;
import com.jme.light.SimpleLightNode;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;

public class TestLightStateController
extends SimpleGame {
    Node colornode;
    static final float worldsize = 20.0f;

    public static void main(String[] stringArray) {
        TestLightStateController testLightStateController = new TestLightStateController();
        testLightStateController.setDialogBehaviour(2);
        testLightStateController.start();
    }

    void randomLight(int n) {
        ColorRGBA colorRGBA = ColorRGBA.randomColor();
        Sphere sphere = new Sphere("lp" + n, 10, 10, 0.1f);
        sphere.setModelBound((BoundingVolume)new BoundingSphere());
        sphere.updateModelBound();
        sphere.setLightCombineMode(0);
        sphere.setDefaultColor(colorRGBA);
        PointLight pointLight = new PointLight();
        pointLight.setAttenuate(true);
        pointLight.setConstant(0.1f);
        pointLight.setLinear(0.1f);
        pointLight.setQuadratic(0.1f);
        pointLight.setEnabled(true);
        pointLight.setDiffuse(colorRGBA);
        pointLight.setAmbient(new ColorRGBA(0.1f, 0.1f, 0.1f, 0.1f));
        LightControllerManager.addLight((Light)pointLight);
        Node node = new Node("P" + n + " Light pos");
        SimpleLightNode simpleLightNode = new SimpleLightNode("ln" + n, (Light)pointLight);
        node.setLocalTranslation(new Vector3f(FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f, FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f, FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f));
        node.attachChild((Spatial)sphere);
        SpatialTransformer spatialTransformer = new SpatialTransformer(1);
        spatialTransformer.setObject((Spatial)node, 0, -1);
        spatialTransformer.setPosition(0, 0.0f, node.getLocalTranslation());
        int n2 = FastMath.rand.nextInt(10) + 1;
        for (int i = 0; i < n2; ++i) {
            spatialTransformer.setPosition(0, (float)(i * 4 + 4), new Vector3f(FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f, FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f, FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f));
        }
        spatialTransformer.setRepeatType(2);
        spatialTransformer.interpolateMissing();
        spatialTransformer.setActive(true);
        node.addController((Controller)spatialTransformer);
        node.attachChild((Spatial)simpleLightNode);
        this.colornode.attachChild((Spatial)node);
    }

    void randomSphere(int n) {
        Sphere sphere = new Sphere("sp" + n, 10, 10, 1.0f);
        sphere.setModelBound((BoundingVolume)new BoundingSphere());
        sphere.updateModelBound();
        sphere.setLocalTranslation(new Vector3f(FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f, FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f, FastMath.rand.nextFloat() * 20.0f * 2.0f - 20.0f));
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        lightState.setEnabled(true);
        sphere.setRenderState((RenderState)lightState);
        LightControllerManager.addSpatial((Spatial)sphere);
        sphere.setLightCombineMode(5);
        this.rootNode.attachChild((Spatial)sphere);
    }

    protected void simpleInitGame() {
        int n;
        this.lightState.detachAll();
        this.colornode = new Node("LightNode");
        for (n = 0; n < 20; ++n) {
            this.randomLight(n);
        }
        for (n = 0; n < 40; ++n) {
            this.randomSphere(n);
        }
        LightState lightState = DisplaySystem.getDisplaySystem().getRenderer().createLightState();
        lightState.setEnabled(false);
        this.colornode.setRenderState((RenderState)lightState);
        this.rootNode.attachChild((Spatial)this.colornode);
        this.rootNode.updateRenderState();
    }
}

