/*
 * Decompiled with CFR 0.152.
 */
package jmetest.util;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Pyramid;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import java.net.URL;
import java.util.logging.Level;

public class TestTimer
extends BaseGame {
    private TriMesh t;
    private Camera cam;
    private Text text;
    private Node root;
    private Node scene;
    private InputHandler input;
    private Timer timer;
    private Quaternion rotQuat;
    private float angle = 0.0f;
    private Vector3f axis;

    public static void main(String[] stringArray) {
        TestTimer testTimer = new TestTimer();
        testTimer.setDialogBehaviour(2);
        testTimer.start();
    }

    public void addSpatial(Spatial spatial) {
        this.scene.attachChild(spatial);
        this.scene.updateGeometricState(0.0f, true);
        System.out.println(this.scene.getQuantity());
    }

    protected void update(float f) {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.timer.update();
        this.input.update(this.timer.getTimePerFrame());
        this.text.print("Frame Rate: " + this.timer.getFrameRate());
        this.t.setLocalRotation(this.rotQuat);
        this.scene.updateGeometricState(0.0f, true);
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit", false)) {
            this.finish();
        }
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.root);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f);
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 75.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
        this.input = new FirstPersonHandler(this.cam, 15.0f, 1.0f);
        this.timer = Timer.getTimer();
        LoggingSystem.getLogger().log(Level.INFO, "Timer resolution:" + this.timer.getResolution());
        this.rotQuat = new Quaternion();
        this.axis = new Vector3f(1.0f, 1.0f, 1.0f);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void initGame() {
        this.text = new Text("Text Label", "Timer");
        this.text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestTimer.class.getClassLoader().getResource("jmetest/data/font/font.png"), (int)2, (int)1));
        this.text.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.text.setRenderState((RenderState)alphaState);
        this.scene = new Node("Scene Node");
        this.root = new Node("Root Scene Node");
        this.root.attachChild((Spatial)this.text);
        this.t = new Pyramid("Pyramid", 10.0f, 10.0f);
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.updateModelBound();
        this.t.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.scene.attachChild((Spatial)this.t);
        this.root.attachChild((Spatial)this.scene);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(0.0f, 0.0f, -1.0f));
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.attach((Light)directionalLight);
        directionalLight.setEnabled(true);
        this.scene.setRenderState((RenderState)lightState);
        this.scene.setRenderState((RenderState)zBufferState);
        this.cam.update();
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        textureState2.setEnabled(true);
        textureState2.setTexture(TextureManager.loadTexture((URL)TestTimer.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.scene.setRenderState((RenderState)textureState2);
        this.root.attachChild((Spatial)this.text);
        this.root.updateGeometricState(0.0f, true);
        this.root.updateRenderState();
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

