/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.editors.swing.pass;

import com.jmex.editors.swing.widget.ValueSpinner;
import com.jmex.effects.glsl.BloomRenderPass;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BloomPassEditor
extends JPanel {
    private JCheckBox enabledCheckBox;
    private JRadioButton rerenderToPbufferRadioButton;
    private JRadioButton reuseFramebufferRadioButton;
    private static final long serialVersionUID = 1L;
    private ButtonGroup modeBG = new ButtonGroup();
    private ValueSpinner throttleField;
    private ValueSpinner sizeField;
    private ValueSpinner passesField;
    private ValueSpinner intensityField;
    private ValueSpinner powerField;
    private ValueSpinner cutoffField;
    private float origSize;
    private float origIntens;
    private float origPower;
    private float origCutoff;
    private int origPasses;
    private int origThrottleMS;
    private boolean origUseCurrent;
    protected File lastDir;

    public BloomPassEditor(final BloomRenderPass bloomRenderPass) {
        this.origCutoff = bloomRenderPass.getExposureCutoff();
        this.origIntens = bloomRenderPass.getBlurIntensityMultiplier();
        this.origPasses = bloomRenderPass.getNrBlurPasses();
        this.origPower = bloomRenderPass.getExposurePow();
        this.origSize = bloomRenderPass.getBlurSize();
        this.origUseCurrent = bloomRenderPass.useCurrentScene();
        this.origThrottleMS = (int)(bloomRenderPass.getThrottle() * 1000.0f);
        this.setLayout(new GridBagLayout());
        this.enabledCheckBox = new JCheckBox();
        this.enabledCheckBox.setSelected(bloomRenderPass.isEnabled());
        this.enabledCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                bloomRenderPass.setEnabled(BloomPassEditor.this.enabledCheckBox.isSelected());
            }
        });
        this.enabledCheckBox.setText("Bloom Enabled");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.enabledCheckBox, gridBagConstraints);
        JPanel jPanel = new JPanel();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        this.add((Component)jPanel, gridBagConstraints2);
        JLabel jLabel = new JLabel();
        jLabel.setText("Update Freq. (ms):");
        jPanel.add(jLabel);
        this.throttleField = new ValueSpinner(0, 1000, 1);
        this.throttleField.setValue((int)(bloomRenderPass.getThrottle() * 1000.0f));
        this.throttleField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                bloomRenderPass.setThrottle((float)((Number)BloomPassEditor.this.throttleField.getValue()).intValue() / 1000.0f);
            }
        });
        jPanel.add(this.throttleField);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 1));
        jPanel2.setBorder(new TitledBorder(null, "Render Mode", 0, 0, null, null));
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.gridx = 0;
        this.add((Component)jPanel2, gridBagConstraints3);
        this.reuseFramebufferRadioButton = new JRadioButton();
        if (bloomRenderPass.useCurrentScene()) {
            this.reuseFramebufferRadioButton.setSelected(true);
        }
        this.reuseFramebufferRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                bloomRenderPass.setUseCurrentScene(true);
            }
        });
        this.modeBG.add(this.reuseFramebufferRadioButton);
        this.reuseFramebufferRadioButton.setText("Reuse FrameBuffer");
        jPanel2.add(this.reuseFramebufferRadioButton);
        this.rerenderToPbufferRadioButton = new JRadioButton();
        if (!bloomRenderPass.useCurrentScene()) {
            this.rerenderToPbufferRadioButton.setSelected(true);
        }
        this.rerenderToPbufferRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                bloomRenderPass.setUseCurrentScene(false);
            }
        });
        this.modeBG.add(this.rerenderToPbufferRadioButton);
        this.rerenderToPbufferRadioButton.setText("Rerender to PBuffer");
        jPanel2.add(this.rerenderToPbufferRadioButton);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2));
        jPanel3.setBorder(new TitledBorder(null, "Exposure Settings", 0, 0, null, null));
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.gridy = 3;
        gridBagConstraints4.gridx = 0;
        this.add((Component)jPanel3, gridBagConstraints4);
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Power:");
        jPanel3.add(jLabel2);
        this.powerField = new ValueSpinner(0.0f, 32.0f, 0.01f);
        this.powerField.setValue(Float.valueOf(bloomRenderPass.getExposurePow()));
        this.powerField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                bloomRenderPass.setExposurePow(((Number)BloomPassEditor.this.powerField.getValue()).floatValue());
            }
        });
        jPanel3.add(this.powerField);
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Cutoff:");
        jPanel3.add(jLabel3);
        this.cutoffField = new ValueSpinner(0.0f, 10.0f, 0.01f);
        this.cutoffField.setValue(Float.valueOf(bloomRenderPass.getExposureCutoff()));
        this.cutoffField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                bloomRenderPass.setExposureCutoff(((Number)BloomPassEditor.this.cutoffField.getValue()).floatValue());
            }
        });
        jPanel3.add(this.cutoffField);
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new TitledBorder(null, "Blur Settings", 0, 0, null, null));
        jPanel4.setLayout(new GridLayout(0, 2));
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.gridy = 4;
        gridBagConstraints5.gridx = 0;
        this.add((Component)jPanel4, gridBagConstraints5);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Passes:");
        jPanel4.add(jLabel4);
        this.passesField = new ValueSpinner(0, 16, 1);
        this.passesField.setValue(bloomRenderPass.getNrBlurPasses());
        this.passesField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                bloomRenderPass.setNrBlurPasses(((Number)BloomPassEditor.this.passesField.getValue()).intValue());
            }
        });
        jPanel4.add(this.passesField);
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Intensity:");
        jPanel4.add(jLabel5);
        this.intensityField = new ValueSpinner(0.0f, 16.0f, 0.01f);
        this.intensityField.setValue(Float.valueOf(bloomRenderPass.getBlurIntensityMultiplier()));
        this.intensityField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                bloomRenderPass.setBlurIntensityMultiplier(((Number)BloomPassEditor.this.intensityField.getValue()).floatValue());
            }
        });
        jPanel4.add(this.intensityField);
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Size:");
        jPanel4.add(jLabel6);
        this.sizeField = new ValueSpinner(0.0f, 16.0f, 0.001f);
        this.sizeField.setValue(Float.valueOf(bloomRenderPass.getBlurSize()));
        this.sizeField.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                bloomRenderPass.setBlurSize(((Number)BloomPassEditor.this.sizeField.getValue()).floatValue());
            }
        });
        jPanel4.add(this.sizeField);
        this.setSize(218, 359);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridy = 5;
        gridBagConstraints6.gridx = 0;
        this.add((Component)jPanel5, gridBagConstraints6);
        JButton jButton = new JButton();
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = BloomPassEditor.this.lastDir != null ? new JFileChooser(BloomPassEditor.this.lastDir) : new JFileChooser();
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showSaveDialog(BloomPassEditor.this);
                if (n == 1) {
                    return;
                }
                BloomPassEditor.this.lastDir = jFileChooser.getCurrentDirectory();
                BloomPassEditor.this.origCutoff = bloomRenderPass.getExposureCutoff();
                BloomPassEditor.this.origIntens = bloomRenderPass.getBlurIntensityMultiplier();
                BloomPassEditor.this.origPasses = bloomRenderPass.getNrBlurPasses();
                BloomPassEditor.this.origThrottleMS = (int)(bloomRenderPass.getThrottle() * 1000.0f);
                BloomPassEditor.this.origPower = bloomRenderPass.getExposurePow();
                BloomPassEditor.this.origSize = bloomRenderPass.getBlurSize();
                BloomPassEditor.this.origUseCurrent = bloomRenderPass.useCurrentScene();
                File file = jFileChooser.getSelectedFile();
                Properties properties = new Properties();
                properties.put("cutoff", "" + BloomPassEditor.this.origCutoff);
                properties.put("intensity", "" + BloomPassEditor.this.origIntens);
                properties.put("passes", "" + BloomPassEditor.this.origPasses);
                properties.put("throttleMS", "" + BloomPassEditor.this.origThrottleMS);
                properties.put("power", "" + BloomPassEditor.this.origPower);
                properties.put("size", "" + BloomPassEditor.this.origSize);
                properties.put("useCurrent", "" + BloomPassEditor.this.origUseCurrent);
                try {
                    properties.storeToXML(new FileOutputStream(file), "Bloom properties.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        jButton.setText("Export...");
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(2, 2, 0, 4);
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 0;
        jPanel5.add((Component)jButton, gridBagConstraints7);
        JButton jButton2 = new JButton();
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = BloomPassEditor.this.lastDir != null ? new JFileChooser(BloomPassEditor.this.lastDir) : new JFileChooser();
                jFileChooser.setMultiSelectionEnabled(false);
                int n = jFileChooser.showOpenDialog(BloomPassEditor.this);
                if (n == 1) {
                    return;
                }
                BloomPassEditor.this.lastDir = jFileChooser.getCurrentDirectory();
                File file = jFileChooser.getSelectedFile();
                Properties properties = new Properties();
                try {
                    properties.loadFromXML(new BufferedInputStream(new FileInputStream(file)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
                BloomPassEditor.this.origCutoff = Float.parseFloat(properties.getProperty("cutoff", "0.0"));
                BloomPassEditor.this.origIntens = Float.parseFloat(properties.getProperty("intensity", "1.3"));
                BloomPassEditor.this.origPasses = Integer.parseInt(properties.getProperty("passes", "2"));
                BloomPassEditor.this.origThrottleMS = Integer.parseInt(properties.getProperty("throttleMS", "20"));
                BloomPassEditor.this.origPower = Float.parseFloat(properties.getProperty("power", "3.0"));
                BloomPassEditor.this.origSize = Float.parseFloat(properties.getProperty("size", "0.02"));
                BloomPassEditor.this.origUseCurrent = Boolean.parseBoolean(properties.getProperty("useCurrent", "true"));
                BloomPassEditor.this.revert(bloomRenderPass);
            }
        });
        jButton2.setText("Import...");
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(2, 4, 0, 2);
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 0;
        jPanel5.add((Component)jButton2, gridBagConstraints8);
        JButton jButton3 = new JButton();
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints9.gridwidth = 2;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 1;
        jPanel5.add((Component)jButton3, gridBagConstraints9);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BloomPassEditor.this.revert(bloomRenderPass);
            }
        });
        jButton3.setText("Reset");
    }

    private void revert(BloomRenderPass bloomRenderPass) {
        this.intensityField.setValue(Float.valueOf(this.origIntens));
        this.sizeField.setValue(Float.valueOf(this.origSize));
        this.cutoffField.setValue(Float.valueOf(this.origCutoff));
        this.powerField.setValue(Float.valueOf(this.origPower));
        this.throttleField.setValue(this.origThrottleMS);
        this.passesField.setValue(this.origPasses);
        bloomRenderPass.setUseCurrentScene(this.origUseCurrent);
        if (this.origUseCurrent) {
            this.reuseFramebufferRadioButton.setSelected(true);
        } else {
            this.rerenderToPbufferRadioButton.setSelected(true);
        }
    }

    public static JFrame makeFrame(BloomRenderPass bloomRenderPass) {
        JFrame jFrame = new JFrame("Bloom Settings");
        BloomPassEditor bloomPassEditor = new BloomPassEditor(bloomRenderPass);
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)bloomPassEditor, "Center");
        jFrame.pack();
        return jFrame;
    }
}

