/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.fmod.objects;

import com.jme.math.Vector3f;
import com.jme.util.LoggingSystem;
import com.jmex.sound.fmod.objects.Listener;
import com.jmex.sound.fmod.scene.Configuration;
import com.jmex.sound.fmod.scene.SoundSpatial;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import org.lwjgl.BufferUtils;
import org.lwjgl.fmod3.FSound;
import org.lwjgl.fmod3.FSoundDSPUnit;
import org.lwjgl.fmod3.FSoundSample;

public class Sample3D
extends SoundSpatial
implements Cloneable {
    private FSoundSample fmodSample;
    private int ray;
    private int min = 1;
    private FloatBuffer position = BufferUtils.createFloatBuffer((int)3);
    private FloatBuffer velocity = BufferUtils.createFloatBuffer((int)3);
    private static Vector3f workVec = new Vector3f();
    private boolean handlesEvent;
    private int actualVolume = -1;
    private URL file;
    public static final int METHOD_PAUSE = 1;
    public static final int METHOD_STOP = 2;
    public static final int METHOD_MUTE = 3;
    float posx = 0.0f;
    private int method;
    private int[] event;

    private Sample3D() {
    }

    public Sample3D(String string) {
        this.fmodSample = this.init(string);
    }

    public Sample3D(Listener listener, String string, int n) {
        this(string);
        this.listener = listener;
        this.method = n;
    }

    public Sample3D(Listener listener, URL uRL, int n) {
        this.fmodSample = this.init(uRL);
        this.listener = listener;
        this.method = n;
    }

    private FSoundSample init(String string) {
        URL uRL;
        this.file = uRL = Sample3D.class.getClassLoader().getResource(string);
        return this.init(uRL);
    }

    private FSoundSample init(URL uRL) {
        FSoundSample fSoundSample = FSound.FSOUND_Sample_Load((int)-2, (String)uRL.getFile().substring(1), (int)0x141000, (int)0, (int)0);
        if (fSoundSample == null) {
            fSoundSample = FSound.FSOUND_Sample_Load((int)-2, (String)uRL.getFile(), (int)0x141000, (int)0, (int)0);
        }
        LoggingSystem.getLogger().log(Level.INFO, "Load file:" + uRL.getFile() + " Success=" + (this.fmodSample != null));
        return fSoundSample;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setRenderMethod(int n) {
        this.method = n;
    }

    public void draw() {
        if (this.handlesEvent) {
            return;
        }
        workVec.set(this.position.get(0), this.position.get(1), this.position.get(2));
        float f = this.listener.getPosition().distance(workVec);
        if (f > (float)this.ray) {
            if (this.method == 1) {
                this.pause();
            } else if (this.method == 2) {
                this.stop();
            } else if (this.method == 3) {
                this.mute();
            }
        } else if (!this.isPlaying()) {
            this.play();
        } else if (this.method == 1 && !this.isPaused()) {
            this.pause();
        } else if (this.method == 3 && this.actualVolume != -1) {
            this.setVolume(this.actualVolume);
        }
    }

    public boolean play() {
        if (this.fmodSample == null) {
            return false;
        }
        this.playingChannel = FSound.nFSOUND_PlaySoundEx((int)-1, (FSoundSample)this.fmodSample, (FSoundDSPUnit)FSound.FSOUND_DSP_GetSFXUnit(), (boolean)true);
        if (this.playingChannel != -1) {
            this.configure();
            FSound.FSOUND_SetPriority((int)this.playingChannel, (int)255);
            FSound.FSOUND_3D_SetDistanceFactor((float)1.0f);
            FSound.FSOUND_3D_SetMinMaxDistance((int)this.playingChannel, (float)this.min, (float)this.ray);
            FSound.FSOUND_3D_SetAttributes((int)this.playingChannel, (FloatBuffer)this.position, (FloatBuffer)this.velocity);
            FSound.FSOUND_SetPaused((int)this.playingChannel, (boolean)false);
            return true;
        }
        return false;
    }

    public boolean pause() {
        return FSound.FSOUND_SetPaused((int)this.playingChannel, (!FSound.FSOUND_GetPaused((int)this.playingChannel) ? 1 : 0) != 0);
    }

    public boolean isPaused() {
        return FSound.FSOUND_GetPaused((int)this.playingChannel);
    }

    public boolean stop() {
        return FSound.FSOUND_StopSound((int)this.playingChannel);
    }

    public boolean isPlaying() {
        return FSound.FSOUND_IsPlaying((int)this.playingChannel);
    }

    public void mute() {
        if (this.actualVolume == -1) {
            this.actualVolume = FSound.FSOUND_GetVolume((int)this.playingChannel);
        }
        this.setVolume(0);
    }

    public void setPosition(float f, float f2, float f3) {
        this.position.clear();
        this.position.put(f);
        this.position.put(f2);
        this.position.put(f3);
        this.position.position(0);
    }

    public void setVelocity(float f, float f2, float f3) {
        this.velocity.clear();
        this.velocity.put(f);
        this.velocity.put(f2);
        this.velocity.put(f3);
    }

    public void setMinDistance(int n) {
        this.min = n;
        FSound.FSOUND_3D_SetMinMaxDistance((int)this.playingChannel, (float)n, (float)this.ray);
    }

    public void setVolume(int n) {
        FSound.FSOUND_SetVolume((int)this.playingChannel, (int)n);
    }

    public void setMaxAudibleDistance(int n) {
        this.ray = n;
    }

    private void configure() {
        if (this.configuration != null && !this.configured) {
            if (this.configuration.isFxEnabled()) {
                FSound.FSOUND_SetPaused((int)this.playingChannel, (boolean)true);
                float[] fArray = null;
                if (this.configuration.isChorusEnabled()) {
                    this.setFxChorusID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)0));
                    if (this.getFxChorusID() != -1) {
                        fArray = this.configuration.getChorusParams();
                        FSound.FSOUND_FX_SetChorus((int)this.getFxChorusID(), (float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3], (int)((int)fArray[4]), (float)fArray[5], (int)((int)fArray[6]));
                    }
                }
                if (this.configuration.isCompressorEnabled()) {
                    this.setFxCompressorID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)1));
                    if (this.getFxCompressorID() != -1) {
                        fArray = this.configuration.getCompressorParams();
                        FSound.FSOUND_FX_SetCompressor((int)this.getFxCompressorID(), (float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3], (float)fArray[4], (float)fArray[5]);
                    }
                }
                if (this.configuration.isDistorsionEnabled()) {
                    this.setFxDistorsionID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)2));
                    if (this.getFxDistorsionID() != -1) {
                        fArray = this.configuration.getDistorsionParams();
                        FSound.FSOUND_FX_SetDistortion((int)this.getFxDistorsionID(), (float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3], (float)fArray[4]);
                    }
                }
                if (this.configuration.isEchoEnabled()) {
                    this.setFxEchoID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)3));
                    if (this.getFxEchoID() != -1) {
                        fArray = this.configuration.getEchoParams();
                        FSound.FSOUND_FX_SetEcho((int)this.getFxEchoID(), (float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3], (int)((int)fArray[4]));
                    }
                }
                if (this.configuration.isEqEnabled()) {
                    this.setFxParamEqID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)7));
                    if (this.getFxParamEqID() != -1) {
                        fArray = this.configuration.getEqParams();
                        FSound.FSOUND_FX_SetParamEQ((int)this.getFxParamEqID(), (float)fArray[0], (float)fArray[1], (float)fArray[2]);
                    }
                }
                if (this.configuration.isFlangerEnabled()) {
                    this.setFxFlangerID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)4));
                    if (this.getFxFlangerID() != -1) {
                        fArray = this.configuration.getFlangerParams();
                        FSound.FSOUND_FX_SetFlanger((int)this.getFxFlangerID(), (float)fArray[0], (float)fArray[1], (float)fArray[2], (float)fArray[3], (int)((int)fArray[4]), (float)fArray[5], (int)((int)fArray[6]));
                    }
                }
                if (this.configuration.isGargleEnabled()) {
                    this.setFxGargleID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)5));
                    if (this.getFxGargleID() != -1) {
                        fArray = this.configuration.getGargleParams();
                        FSound.FSOUND_FX_SetGargle((int)this.getFxGargleID(), (int)((int)fArray[0]), (int)((int)fArray[0]));
                    }
                }
                if (this.configuration.isI3DL2ReverbEnabled()) {
                    this.setFxI3DL2ReverbID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)6));
                    if (this.getFxI3DL2ReverbID() != -1) {
                        fArray = this.configuration.getI3DLParams();
                        FSound.FSOUND_FX_SetI3DL2Reverb((int)this.getFxI3DL2ReverbID(), (int)((int)fArray[0]), (int)((int)fArray[0]), (float)fArray[0], (float)fArray[0], (float)fArray[0], (int)((int)fArray[0]), (float)fArray[0], (int)((int)fArray[0]), (float)fArray[0], (float)fArray[0], (float)fArray[0], (float)fArray[0]);
                    }
                }
                if (this.configuration.isReverbEnabled()) {
                    this.setFxWavesReverbID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)8));
                    if (this.getFxWavesReverbID() != -1) {
                        fArray = this.configuration.getReverbParams();
                        FSound.FSOUND_FX_SetWavesReverb((int)this.getFxWavesReverbID(), (float)fArray[0], (float)fArray[0], (float)fArray[0], (float)fArray[0]);
                    }
                }
                if (this.configuration.isMaxEnabled()) {
                    this.setFxMaxID(FSound.FSOUND_FX_Enable((int)this.playingChannel, (int)9));
                }
            }
            this.configured = true;
        }
    }

    public void bindEvent(int n) {
        if (this.event == null) {
            this.event = new int[1];
            this.event[0] = n;
            this.handlesEvent = true;
            return;
        }
        int[] nArray = new int[this.event.length + 1];
        System.arraycopy(this.event, 0, nArray, 0, this.event.length);
        nArray[this.event.length] = n;
        this.event = nArray;
    }

    public boolean fireEvent(int n) {
        if (this.event != null && (this.allowInterrupt || !this.isPlaying())) {
            for (int i = 0; i < this.event.length; ++i) {
                if (this.event[i] != n) continue;
                this.stop();
                this.play();
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        Sample3D sample3D = new Sample3D();
        sample3D.fmodSample = this.fmodSample;
        sample3D.file = this.file;
        sample3D.fmodSample = sample3D.init(sample3D.file);
        sample3D.listener = this.listener;
        sample3D.method = this.method;
        return sample3D;
    }
}

