/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL;

import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.util.LoggingSystem;
import com.jmex.sound.openAL.objects.Listener;
import com.jmex.sound.openAL.objects.MusicStream;
import com.jmex.sound.openAL.objects.Sample3D;
import com.jmex.sound.openAL.objects.util.StreamPlayer;
import com.jmex.sound.openAL.objects.util.dsp.Equalizer;
import com.jmex.sound.openAL.scene.Configuration;
import com.jmex.sound.openAL.scene.SoundNode;
import java.net.URL;
import java.util.logging.Level;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;

public class SoundSystem {
    private static Listener listener;
    private static Camera camera;
    public static final int OUTPUT_DEFAULT = 0;
    public static final int OUTPUT_DSOUND = 1;
    public static final int OUTPUT_WINMM = 2;
    public static final int OUTPUT_ASIO = 3;
    public static final int OUTPUT_OSS = 5;
    public static final int OUTPUT_ESD = 6;
    public static final int OUTPUT_ALSA = 7;
    public static final int OUTPUT_MAC = 8;
    private static int OS_DETECTED;
    private static final int OS_LINUX = 1;
    private static final int OS_WINDOWS = 2;
    private static final int OS_MAC = 3;
    private static SoundNode[] nodes;
    private static Sample3D[] sample3D;
    private static MusicStream[] stream;

    private static void initializeOpenAL() {
        try {
            AL.create();
            AL10.alDistanceModel((int)53249);
            LoggingSystem.getLogger().log(Level.INFO, "OpenAL initalized!");
        }
        catch (Exception exception) {
            LoggingSystem.getLogger().log(Level.SEVERE, "Failed to Initialize OpenAL...");
            exception.printStackTrace();
        }
    }

    private static void detectOS() {
        String string = System.getProperty("os.name");
        if ((string = string.toUpperCase()).startsWith("LINUX")) {
            OS_DETECTED = 1;
        }
        if (string.startsWith("WINDOWS")) {
            OS_DETECTED = 2;
        }
        if (string.startsWith("MAC")) {
            OS_DETECTED = 3;
        }
    }

    public static void init(Camera camera, int n) {
        SoundSystem.camera = camera;
        if (n == 0) {
            n = OS_DETECTED;
        }
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public static Camera getCamera() {
        return camera;
    }

    public static void setCamera(Camera camera) {
        SoundSystem.camera = camera;
        SoundSystem.updateListener();
    }

    private static void updateListener() {
        if (camera != null) {
            listener.setPosition(camera.getLocation());
        }
        float[] fArray = listener.getOrientation();
        Vector3f vector3f = null;
        Vector3f vector3f2 = null;
        if (camera != null) {
            vector3f = camera.getDirection();
            vector3f2 = camera.getUp();
        } else if (vector3f == null) {
            vector3f = new Vector3f(0.0f, 0.0f, -1.0f);
            vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
        }
        fArray[0] = vector3f.x;
        fArray[1] = vector3f.y;
        fArray[2] = vector3f.z;
        fArray[3] = vector3f2.x;
        fArray[4] = vector3f2.y;
        fArray[5] = vector3f2.z;
        listener.update();
    }

    public static void update(float f) {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].updateWorldData(f);
        }
        SoundSystem.updateListener();
    }

    public static void update(int n, float f) {
        if (nodes == null) {
            return;
        }
        if (n < 0 || n >= nodes.length) {
            return;
        }
        nodes[n].updateWorldData(f);
        SoundSystem.updateListener();
    }

    public static void draw() {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].draw();
        }
    }

    public static void draw(int n) {
        if (nodes == null) {
            return;
        }
        if (n < 0 || n >= nodes.length) {
            return;
        }
        nodes[n].draw();
    }

    public static int createSoundNode() {
        if (nodes == null) {
            nodes = new SoundNode[1];
            SoundSystem.nodes[0] = new SoundNode();
            return 0;
        }
        SoundNode[] soundNodeArray = new SoundNode[nodes.length];
        System.arraycopy(nodes, 0, soundNodeArray, 0, soundNodeArray.length);
        nodes = new SoundNode[soundNodeArray.length + 1];
        System.arraycopy(soundNodeArray, 0, nodes, 0, soundNodeArray.length);
        SoundSystem.nodes[soundNodeArray.length] = new SoundNode();
        return soundNodeArray.length;
    }

    public static int create3DSample(URL uRL) {
        if (sample3D == null) {
            sample3D = new Sample3D[1];
            SoundSystem.sample3D[0] = new Sample3D(listener, uRL);
            return 0;
        }
        Sample3D[] sample3DArray = new Sample3D[sample3D.length];
        System.arraycopy(sample3D, 0, sample3DArray, 0, sample3DArray.length);
        sample3D = new Sample3D[sample3DArray.length + 1];
        System.arraycopy(sample3DArray, 0, sample3D, 0, sample3DArray.length);
        SoundSystem.sample3D[sample3DArray.length] = new Sample3D(listener, uRL);
        return sample3DArray.length;
    }

    public static int cloneSample(int n) {
        if (sample3D == null) {
            return -1;
        }
        if (sample3D != null && sample3D.length < n) {
            return -1;
        }
        Sample3D[] sample3DArray = new Sample3D[sample3D.length];
        System.arraycopy(sample3D, 0, sample3DArray, 0, sample3DArray.length);
        sample3D = new Sample3D[sample3DArray.length + 1];
        System.arraycopy(sample3DArray, 0, sample3D, 0, sample3DArray.length);
        SoundSystem.sample3D[sample3DArray.length] = (Sample3D)sample3D[n].clone();
        return sample3DArray.length;
    }

    public static int createStream(String string, boolean bl) {
        if (stream == null) {
            stream = new MusicStream[1];
            SoundSystem.stream[0] = new MusicStream(string, bl);
            return 0;
        }
        MusicStream[] musicStreamArray = new MusicStream[stream.length];
        System.arraycopy(stream, 0, musicStreamArray, 0, musicStreamArray.length);
        stream = new MusicStream[musicStreamArray.length + 1];
        System.arraycopy(musicStreamArray, 0, stream, 0, musicStreamArray.length);
        SoundSystem.stream[musicStreamArray.length] = new MusicStream(string, bl);
        return musicStreamArray.length;
    }

    public static boolean isStreamOpened(int n) {
        if (stream == null) {
            return false;
        }
        if (n < 0 || n >= stream.length) {
            return false;
        }
        return stream[n].isOpened();
    }

    public static void setStreamLooping(int n, boolean bl) {
        if (stream == null) {
            return;
        }
        if (n < 0 || n >= stream.length) {
            return;
        }
        stream[n].loop(bl);
    }

    public static float getStreamLength(int n) {
        if (stream == null) {
            return -1.0f;
        }
        if (n < 0 || n >= stream.length) {
            return -1.0f;
        }
        return stream[n].length();
    }

    public static boolean playStream(int n) {
        if (stream == null) {
            return false;
        }
        if (n < 0 || n >= stream.length) {
            return false;
        }
        return stream[n].play();
    }

    public static boolean pauseStream(int n) {
        if (stream == null) {
            return false;
        }
        if (n < 0 || n >= stream.length) {
            return false;
        }
        return stream[n].pause();
    }

    public static void stopStream(int n) {
        if (stream == null) {
            return;
        }
        if (n < 0 || n >= stream.length) {
            return;
        }
        stream[n].stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void stopAllSamples() {
        if (sample3D == null) return;
        Sample3D[] sample3DArray = sample3D;
        synchronized (sample3D) {
            for (int i = 0; i < sample3D.length; ++i) {
                sample3D[i].stop();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void cleanSamples() {
        if (sample3D == null) return;
        Sample3D[] sample3DArray = sample3D;
        synchronized (sample3D) {
            for (int i = 0; i < sample3D.length; ++i) {
                sample3D[i].delete();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            sample3D = null;
            return;
        }
    }

    public static void setSamplePosition(int n, float f, float f2, float f3) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].setPosition(f, f2, f3);
    }

    public static void setSampleVelocity(int n, float f, float f2, float f3) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].setVelocity(f, f2, f3);
    }

    public static void setSampleConfig(int n, Configuration configuration) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].setConfiguration(configuration);
    }

    public static void bindEventToSample(int n, int n2) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].bindEvent(n2);
    }

    public static void onEvent(int n) {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].onEvent(n);
        }
    }

    public static void onEvent(int n, int n2) {
        if (nodes == null) {
            return;
        }
        if (n < 0 || n >= nodes.length) {
            return;
        }
        nodes[n].onEvent(n2);
    }

    public static void setStreamConfig(int n, Configuration configuration) {
        if (stream == null) {
            return;
        }
        if (n < 0 || n >= stream.length) {
            return;
        }
        stream[n].setConfiguration(configuration);
    }

    public static void setSampleMaxAudibleDistance(int n, int n2) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].setMaxAudibleDistance(n2);
    }

    public static void setSampleMinAudibleDistance(int n, int n2) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].setMinDistance(n2);
    }

    public static void addSampleToNode(int n, int n2) {
        if (nodes == null) {
            return;
        }
        if (sample3D == null) {
            return;
        }
        if (n2 < 0 || n2 >= nodes.length) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        nodes[n2].attachChild(sample3D[n]);
    }

    public static void setRolloffFactor(float f) {
        for (int i = 0; i < sample3D.length; ++i) {
            SoundSystem.setSampleRolloffFactor(i, f);
        }
    }

    public static void setSampleRolloffFactor(int n, float f) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].setRolloffFactor(f);
    }

    public static void setSampleVolume(int n, float f) {
        if (sample3D == null) {
            return;
        }
        if (n < 0 || n >= sample3D.length) {
            return;
        }
        sample3D[n].setVolume(f);
    }

    public static void setNodeVolume(int n, float f) {
        if (nodes == null) {
            return;
        }
        if (n < 0 || n >= nodes.length) {
            return;
        }
        for (int i = 0; i < nodes[n].getQuantity(); ++i) {
            ((Sample3D)nodes[n].getChild(i)).setVolume(f);
        }
    }

    public static void setEqualizer(Equalizer equalizer) {
        StreamPlayer.getInstance().setEqualizer(equalizer);
    }

    public static int createStream(URL uRL) {
        return SoundSystem.createStream(uRL, false);
    }

    public static int createStream(URL uRL, boolean bl) {
        if (stream == null) {
            stream = new MusicStream[1];
            SoundSystem.stream[0] = new MusicStream(uRL, bl);
            return 0;
        }
        MusicStream[] musicStreamArray = new MusicStream[stream.length];
        System.arraycopy(stream, 0, musicStreamArray, 0, musicStreamArray.length);
        stream = new MusicStream[musicStreamArray.length + 1];
        System.arraycopy(musicStreamArray, 0, stream, 0, musicStreamArray.length);
        SoundSystem.stream[musicStreamArray.length] = new MusicStream(uRL, bl);
        return musicStreamArray.length;
    }

    public static void setStreamVolume(int n, float f) {
        if (stream == null) {
            return;
        }
        if (n < 0 || n >= stream.length) {
            return;
        }
        stream[n].setVolume(f);
    }

    public static boolean isSamplePlaying(int n) {
        return sample3D[n].isPlaying();
    }

    public static void playSample(int n) {
        sample3D[n].play();
    }

    public static void pauseSample(int n) {
        sample3D[n].pause();
    }

    public static void stopSample(int n) {
        sample3D[n].stop();
    }

    static {
        LoggingSystem.getLogger().log(Level.INFO, "DETECT OPERATING SYSTEM");
        SoundSystem.detectOS();
        LoggingSystem.getLogger().log(Level.INFO, "CREATE OPENAL");
        SoundSystem.initializeOpenAL();
        LoggingSystem.getLogger().log(Level.INFO, "CREATE LISTENER");
        listener = new Listener();
    }
}

