/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.sound.openAL.objects;

import com.jmex.sound.openAL.objects.util.StreamPlayer;
import com.jmex.sound.openAL.scene.Configuration;
import com.jmex.sound.openAL.scene.Playable;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class MusicStream
extends Playable {
    private ByteBuffer memoryData;
    private boolean opened = true;
    private boolean memory;
    private String streamFile;
    private Configuration configuration;

    public MusicStream(String string, boolean bl) {
        this.streamFile = string;
        if (!bl) {
            this.sourceNumber = StreamPlayer.getInstance().openStream(string);
        }
    }

    public MusicStream(URL uRL) {
        this.streamFile = uRL.getFile();
        this.sourceNumber = StreamPlayer.getInstance().openStream(uRL);
    }

    public MusicStream(URL uRL, boolean bl) {
        this.streamFile = uRL.getFile();
        if (!bl) {
            this.sourceNumber = StreamPlayer.getInstance().openStream(uRL);
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean play() {
        StreamPlayer.getInstance().play(this.sourceNumber);
        return true;
    }

    public boolean pause() {
        return StreamPlayer.getInstance().pauseStream(this.sourceNumber);
    }

    public void stop() {
        StreamPlayer.getInstance().stopStream(this.sourceNumber);
    }

    public void close() {
    }

    public boolean isPlaying() {
        return StreamPlayer.getInstance().isPlaying(this.sourceNumber);
    }

    public int length() {
        return (int)StreamPlayer.getInstance().length(this.sourceNumber);
    }

    protected static ByteBuffer getData(String string) {
        ByteBuffer byteBuffer = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(MusicStream.class.getClassLoader().getResourceAsStream(string));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 4096;
            byte[] byArray = new byte[n];
            int n2 = -1;
            while ((n2 = bufferedInputStream.read(byArray, 0, n)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            bufferedInputStream.close();
            byteBuffer = ByteBuffer.allocateDirect(byteArrayOutputStream.size());
            byteBuffer.order(ByteOrder.nativeOrder());
            byteBuffer.put(byteArrayOutputStream.toByteArray());
            byteBuffer.flip();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteBuffer;
    }

    public boolean isOpened() {
        return this.sourceNumber != -1;
    }

    public void loop(boolean bl) {
        StreamPlayer.getInstance().loopStream(this.sourceNumber, bl);
    }

    public void setVolume(float f) {
        StreamPlayer.getInstance().setVolume(this.sourceNumber, f);
    }
}

